<x-admin.layout title="Add Product">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Add New Product</h2>
    </div>

    <x-admin.card>
        <form action="{{ route('admin.products.store') }}" method="POST">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Basic Information -->
                <div class="md:col-span-2">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Basic Information</h3>
                </div>

                <x-admin.form.select name="category_id" label="Category" :options="$categories->pluck('name_en', 'id')" required />

                <x-admin.form.select
                    name="source"
                    label="Source"
                    :options="['aliexpress' => 'AliExpress', 'amazon' => 'Amazon', 'noon' => 'Noon']"
                    required
                />

                <x-admin.form.input name="product_id" label="Product ID" placeholder="External product ID" />

                <div></div>

                <x-admin.form.input name="name_en" label="Name (English)" required />

                <x-admin.form.input name="name_ar" label="Name (Arabic)" required />

                <x-admin.form.textarea name="description_en" label="Description (English)" rows="4" />

                <x-admin.form.textarea name="description_ar" label="Description (Arabic)" rows="4" />

                <!-- Images & Media -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Images & Media</h3>
                </div>

                <x-admin.form.input name="image_url" label="Image URL" type="url" />

                <x-admin.form.input name="video_url" label="Video URL" type="url" />

                <!-- Pricing -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Pricing</h3>
                </div>

                <x-admin.form.input name="price" label="Price" type="number" step="0.01" required />

                <x-admin.form.select
                    name="currency"
                    label="Currency"
                    :options="['EGP' => 'EGP', 'USD' => 'USD', 'EUR' => 'EUR']"
                    required
                />

                <x-admin.form.input name="discount_price" label="Discount Price" type="number" step="0.01" />

                <x-admin.form.input name="discount" label="Discount (%)" type="number" step="0.01" />

                <!-- Promotion -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Promotion & Commission</h3>
                </div>

                <x-admin.form.input name="promotion_url" label="Promotion URL" type="url" />

                <x-admin.form.input name="direct_commission_rate" label="Direct Commission Rate (%)" type="number" step="0.01" />

                <x-admin.form.input name="estimated_direct_commission" label="Estimated Direct Commission" type="number" step="0.01" />

                <x-admin.form.input name="indirect_commission_rate" label="Indirect Commission Rate (%)" type="number" step="0.01" />
            </div>

            <div class="mt-6 flex items-center justify-end gap-3">
                <a href="{{ route('admin.products.index') }}">
                    <x-admin.form.button type="button" variant="outline">Cancel</x-admin.form.button>
                </a>
                <x-admin.form.button type="submit">Create Product</x-admin.form.button>
            </div>
        </form>
    </x-admin.card>
</x-admin.layout>
