<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['products']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['products']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="ai-comparison-table overflow-x-auto">
    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
        <thead class="bg-gray-50 dark:bg-gray-800">
            <tr>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    Product
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    Price
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    Discount
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    Rating
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    Sales (180d)
                </th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-900 divide-y divide-gray-200 dark:divide-gray-700">
            <?php
                $bestPrice = $products->sortBy(fn($p) => $p->discount_price ?? $p->price)->first();
                $topRated = $products->sortByDesc('positive_feedback')->first();
                $bestDeal = $products->sortByDesc('discount')->first();
            ?>

            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $price = $product->discount_price ?? $product->price;
                    $isBestPrice = $product->id === $bestPrice->id;
                    $isTopRated = $product->id === $topRated->id;
                    $isBestDeal = $product->discount > 0 && $product->id === $bestDeal->id;
                ?>

                <tr class="hover:bg-gray-50 dark:hover:bg-gray-800">
                    <td class="px-4 py-3">
                        <div class="flex items-center gap-2">
                            <?php if($product->image_url): ?>
                                <img src="<?php echo e($product->image_url); ?>" alt="<?php echo e($product->name_en); ?>" class="w-8 h-8 rounded object-cover">
                            <?php endif; ?>
                            <div>
                                <p class="text-sm font-medium text-gray-900 dark:text-white">
                                    <?php echo e(\Illuminate\Support\Str::limit($product->name_en, 30)); ?>

                                </p>
                                <?php if($product->category): ?>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">
                                        <?php echo e($product->category->name_en); ?>

                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </td>

                    <td class="px-4 py-3">
                        <div class="flex items-center gap-2">
                            <span class="text-sm font-medium text-gray-900 dark:text-white">
                                $<?php echo e(number_format($price, 2)); ?>

                            </span>
                            <?php if($isBestPrice): ?>
                                <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400">
                                    Best Price
                                </span>
                            <?php endif; ?>
                        </div>
                    </td>

                    <td class="px-4 py-3">
                        <?php if($product->discount > 0): ?>
                            <div class="flex items-center gap-2">
                                <span class="text-sm font-medium text-gray-900 dark:text-white">
                                    <?php echo e(number_format($product->discount, 0)); ?>%
                                </span>
                                <?php if($isBestDeal): ?>
                                    <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-red-100 dark:bg-red-900/30 text-red-600 dark:text-red-400">
                                        Best Deal
                                    </span>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <span class="text-sm text-gray-400">-</span>
                        <?php endif; ?>
                    </td>

                    <td class="px-4 py-3">
                        <div class="flex items-center gap-2">
                            <div class="flex items-center gap-1">
                                <svg class="w-3.5 h-3.5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                </svg>
                                <span class="text-sm font-medium text-gray-900 dark:text-white">
                                    <?php echo e(number_format($product->positive_feedback, 0)); ?>%
                                </span>
                            </div>
                            <?php if($isTopRated): ?>
                                <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-yellow-100 dark:bg-yellow-900/30 text-yellow-600 dark:text-yellow-400">
                                    Top Rated
                                </span>
                            <?php endif; ?>
                        </div>
                    </td>

                    <td class="px-4 py-3 text-sm text-gray-600 dark:text-gray-400">
                        <?php echo e($product->sales_180day ?? 0); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    
    <div class="mt-4 p-3 bg-gray-50 dark:bg-gray-800 rounded-lg">
        <h4 class="text-xs font-semibold text-gray-700 dark:text-gray-300 mb-2">Key Insights</h4>
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-2 text-xs">
            <div class="flex items-center gap-2">
                <span class="px-1.5 py-0.5 rounded bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 font-medium">Best Price</span>
                <span class="text-gray-600 dark:text-gray-400"><?php echo e($bestPrice->name_en); ?> ($<?php echo e(number_format($bestPrice->discount_price ?? $bestPrice->price, 2)); ?>)</span>
            </div>
            <div class="flex items-center gap-2">
                <span class="px-1.5 py-0.5 rounded bg-yellow-100 dark:bg-yellow-900/30 text-yellow-600 dark:text-yellow-400 font-medium">Top Rated</span>
                <span class="text-gray-600 dark:text-gray-400"><?php echo e($topRated->name_en); ?> (<?php echo e(number_format($topRated->positive_feedback, 0)); ?>%)</span>
            </div>
            <?php if($bestDeal->discount > 0): ?>
            <div class="flex items-center gap-2">
                <span class="px-1.5 py-0.5 rounded bg-red-100 dark:bg-red-900/30 text-red-600 dark:text-red-400 font-medium">Best Deal</span>
                <span class="text-gray-600 dark:text-gray-400"><?php echo e($bestDeal->name_en); ?> (<?php echo e(number_format($bestDeal->discount, 0)); ?>% off)</span>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp0\htdocs\octopus\resources\views/components/ai/comparison-table.blade.php ENDPATH**/ ?>