<!DOCTYPE html>
<html lang="en" class="h-full bg-gray-900">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Octopus</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        /* Animation keyframes for button border effect */
        @keyframes btn-anim1 {
            0% { left: -100%; }
            50%, 100% { left: 100%; }
        }
        @keyframes btn-anim2 {
            0% { top: -100%; }
            50%, 100% { top: 100%; }
        }
        @keyframes btn-anim3 {
            0% { right: -100%; }
            50%, 100% { right: 100%; }
        }
        @keyframes btn-anim4 {
            0% { bottom: -100%; }
            50%, 100% { bottom: 100%; }
        }

        .animate-border span:nth-child(1) {
            animation: btn-anim1 1.5s linear infinite;
        }
        .animate-border span:nth-child(2) {
            animation: btn-anim2 1.5s linear infinite;
            animation-delay: 0.375s;
        }
        .animate-border span:nth-child(3) {
            animation: btn-anim3 1.5s linear infinite;
            animation-delay: 0.75s;
        }
        .animate-border span:nth-child(4) {
            animation: btn-anim4 1.5s linear infinite;
            animation-delay: 1.125s;
        }

        /* Floating label animation */
        .user-box input:focus ~ label,
        .user-box input:not(:placeholder-shown) ~ label {
            top: -20px;
            left: 0;
            font-size: 12px;
        }

        /* Fix autofill white background issue */
        input:-webkit-autofill,
        input:-webkit-autofill:hover,
        input:-webkit-autofill:focus,
        input:-webkit-autofill:active {
            -webkit-box-shadow: 0 0 0 30px #000000 inset !important;
            -webkit-text-fill-color: #ffffff !important;
            transition: background-color 5000s ease-in-out 0s;
        }

        input:-webkit-autofill::first-line {
            font-family: inherit;
            font-size: inherit;
            color: #ffffff;
        }
    </style>
</head>
<body class="h-full">
    <div class="absolute top-1/2 left-1/2 w-full max-w-[400px] p-10 -translate-x-1/2 -translate-y-[55%] rounded-xl bg-black/90 shadow-[0_15px_25px_rgba(0,0,0,0.6)]">
        <!-- Logo -->
        <div class="mb-6 flex justify-center">
            <img src="<?php echo e(asset('storage/logos/octopus-logo.png')); ?>" alt="Octopus Logo" class="h-16 w-auto">
        </div>

        <p class="m-0 mb-8 text-white text-center text-2xl font-bold tracking-widest">
            ADMIN LOGIN
        </p>

        <?php if($errors->any()): ?>
            <div class="mb-6 rounded bg-red-900/50 p-4 text-center text-white text-sm">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.login.submit')); ?>" method="POST" id="loginForm">
            <?php echo csrf_field(); ?>

            <!-- Email/Phone Field -->
            <div class="user-box relative mb-8">
                <input
                    id="email"
                    name="email"
                    type="text"
                    autocomplete="username"
                    required
                    value="<?php echo e(old('email')); ?>"
                    placeholder=" "
                    class="w-full border-b border-white bg-transparent p-2.5 pr-10 text-base text-white outline-none placeholder-transparent"
                >
                <label for="email" class="absolute left-0 top-0 p-2.5 text-base text-white transition-all duration-500 pointer-events-none">
                    Email / Phone
                </label>
            </div>

            <!-- Password Field -->
            <div class="user-box relative mb-8">
                <input
                    id="password"
                    name="password"
                    type="password"
                    autocomplete="new-password"
                    required
                    placeholder=" "
                    class="w-full border-b border-white bg-transparent p-2.5 pr-10 text-base text-white outline-none placeholder-transparent"
                >
                <label for="password" class="absolute left-0 top-0 p-2.5 text-base text-white transition-all duration-500 pointer-events-none">
                    Password
                </label>
                <!-- Show/Hide Password Button -->
                <button
                    type="button"
                    id="togglePassword"
                    class="absolute right-0 top-0 p-2.5 text-white/60 hover:text-white transition-colors cursor-pointer"
                    onclick="togglePasswordVisibility()"
                >
                    <svg id="eyeIcon" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                    </svg>
                    <svg id="eyeOffIcon" class="w-5 h-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                    </svg>
                </button>
            </div>

            <!-- Submit Button with Animated Border -->
            <button type="submit" class="relative inline-block w-full overflow-hidden rounded bg-transparent p-3 text-center text-base font-bold text-white uppercase no-underline transition-all duration-500 tracking-widest hover:bg-white hover:text-[#272727] hover:rounded-md animate-border cursor-pointer">
                <span class="absolute left-0 top-0 h-[2px] w-full bg-gradient-to-r from-transparent to-white"></span>
                <span class="absolute right-0 top-0 h-full w-[2px] bg-gradient-to-b from-transparent to-white"></span>
                <span class="absolute right-0 bottom-0 h-[2px] w-full bg-gradient-to-l from-transparent to-white"></span>
                <span class="absolute left-0 bottom-0 h-full w-[2px] bg-gradient-to-t from-transparent to-white"></span>
                Login
            </button>

            <!-- Remember Me -->
            <div class="mt-10 text-center">
                <label class="flex items-center justify-center gap-2 text-white/60 text-sm">
                    <input type="checkbox" name="remember" value="1" class="rounded border-white/30 bg-transparent text-blue-500 focus:ring-blue-500 focus:ring-offset-gray-900">
                    <span>Remember me</span>
                </label>
            </div>
        </form>

        <?php if(false): ?>
        <p class="mt-8 text-center text-sm text-white/60">
            Don't have an account?
            <a href="#" class="a2 text-white no-underline hover:bg-transparent hover:text-white/60 rounded-md transition-colors">
                Sign up
            </a>
        </p>
        <?php endif; ?>
    </div>

    <script>
        // Toggle password visibility
        function togglePasswordVisibility() {
            const passwordInput = document.getElementById('password');
            const eyeIcon = document.getElementById('eyeIcon');
            const eyeOffIcon = document.getElementById('eyeOffIcon');

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.classList.add('hidden');
                eyeOffIcon.classList.remove('hidden');
            } else {
                passwordInput.type = 'password';
                eyeIcon.classList.remove('hidden');
                eyeOffIcon.classList.add('hidden');
                eyeOffIcon.classList.add('hidden');
            }
        }

        // Handle Enter key for form submission
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('loginForm');
            const inputs = form.querySelectorAll('input');

            inputs.forEach(function(input) {
                input.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        form.submit();
                    }
                });
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp0\htdocs\octopus\resources\views/auth/admin-login.blade.php ENDPATH**/ ?>