<?php

use App\Http\Controllers\Admin\AdminAdvertisementController;
use App\Http\Controllers\Admin\AdminAiChatController;
use App\Http\Controllers\Admin\AdminAiProviderController;
use App\Http\Controllers\Admin\AdminCategoryController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\AdminProductController;
use App\Http\Controllers\Admin\AdminSettingsController;
use App\Http\Controllers\Auth\AdminLoginController;
use App\Http\Controllers\DocsController;
use App\Http\Controllers\ProductImportController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
})->name('home');

Route::get('/api-docs', [DocsController::class, 'api'])->name('api.docs');

Route::get('/products/import', [ProductImportController::class, 'index'])->name('products.import');
Route::post('/products/import', [ProductImportController::class, 'store'])->name('products.import.store');

// Admin authentication routes (no middleware)
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('login', [AdminLoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [AdminLoginController::class, 'login'])->name('login.submit');
});

// Protected admin routes (with auth + admin middleware)
Route::prefix('admin')->name('admin.')->middleware(['auth', 'admin'])->group(function () {
    Route::post('logout', [AdminLoginController::class, 'logout'])->name('logout');

    // Admin API endpoints for AJAX calls
    Route::prefix('api')->name('api.')->group(function () {
        Route::get('/products/existing-ids', [AdminProductController::class, 'getExistingProductIds'])->name('products.existing-ids');
    });

    // Dashboard
    Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');

    // Products
    Route::get('products/import', [AdminProductController::class, 'import'])->name('products.import');
    Route::post('products/import', [AdminProductController::class, 'storeImport'])->name('products.import.store');
    Route::resource('products', AdminProductController::class);

    // Categories
    Route::resource('categories', AdminCategoryController::class);

    // Advertisements
    Route::resource('advertisements', AdminAdvertisementController::class);

    // AI Chat
    Route::prefix('ai-chat')->name('ai-chat.')->group(function () {
        Route::get('/', [AdminAiChatController::class, 'index'])->name('index');
        Route::post('create', [AdminAiChatController::class, 'create'])->name('create');
        Route::get('{ulid}', [AdminAiChatController::class, 'show'])->name('show');
        Route::post('{ulid}/message', [AdminAiChatController::class, 'store'])->name('message');
        Route::post('{ulid}/stream', [AdminAiChatController::class, 'stream'])->name('stream');
        Route::delete('{ulid}', [AdminAiChatController::class, 'delete'])->name('delete');
    });

    // AI Providers
    Route::prefix('ai-providers')->name('ai-providers.')->group(function () {
        Route::get('/', [AdminAiProviderController::class, 'index'])->name('index');
        Route::get('create', [AdminAiProviderController::class, 'create'])->name('create');
        Route::post('/', [AdminAiProviderController::class, 'store'])->name('store');
        Route::get('{ai_provider}/edit', [AdminAiProviderController::class, 'edit'])->name('edit');
        Route::put('{ai_provider}', [AdminAiProviderController::class, 'update'])->name('update');
        Route::delete('{ai_provider}', [AdminAiProviderController::class, 'destroy'])->name('destroy');
        Route::post('{ai_provider}/default', [AdminAiProviderController::class, 'setDefault'])->name('set-default');
        Route::post('{ai_provider}/toggle', [AdminAiProviderController::class, 'toggle'])->name('toggle');
    });

    // Settings
    Route::get('settings', [AdminSettingsController::class, 'index'])->name('settings.index');
    Route::put('settings', [AdminSettingsController::class, 'update'])->name('settings.update');
});
