<?php

use App\Http\Controllers\API\V1\AdvertisementController;
use App\Http\Controllers\API\V1\AssistantController;
use App\Http\Controllers\API\V1\AuthController;
use App\Http\Controllers\API\V1\CategoryController;
use App\Http\Controllers\API\V1\FavouriteController;
use App\Http\Controllers\API\V1\GoogleAuthController;
use App\Http\Controllers\API\V1\HistoryController;
use App\Http\Controllers\API\V1\HomeController;
use App\Http\Controllers\API\V1\ProductController;
use App\Http\Controllers\API\V1\ProfileController;
use App\Http\Controllers\API\V1\RegisterController;
use App\Http\Controllers\API\V1\SearchController;
use App\Http\Controllers\API\V1\SettingsController;
use Illuminate\Support\Facades\Route;

// Public routes (v1)
// http://localhost/api/v1/register
Route::prefix('v1')->group(function () {
    Route::post('/register', [RegisterController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/auth/google', GoogleAuthController::class);
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword'])->middleware('throttle:5,1');
    Route::post('/reset-password', [AuthController::class, 'resetPassword'])->middleware('throttle:5,1');
    Route::apiResource('/categories', CategoryController::class, ['only' => ['index', 'show']]);
    Route::get('/categories/{category}/subcategories-products', [CategoryController::class, 'subcategoriesProducts']);
    Route::get('/products', [ProductController::class, 'index']);
    Route::get('/search', [SearchController::class, 'search']);
    Route::apiResource('/advertisements', AdvertisementController::class, ['only' => ['index']]);
    Route::get('/home', [HomeController::class, 'index']);

    // AI Assistant routes (guest users with rate limiting)
    Route::post('/assistant/chat/free', [AssistantController::class, 'chat']);
    Route::get('/assistant/suggestions', [AssistantController::class, 'getSuggestions']);

    // AI Assistant routes (authenticated users - no rate limiting)
    Route::prefix('assistant')->group(function () {
        Route::post('/chat', [AssistantController::class, 'chat']);
        Route::post('/stream', [AssistantController::class, 'stream']);
        Route::get('/conversations', [AssistantController::class, 'conversations']);
        Route::get('/conversations/{ulid}', [AssistantController::class, 'conversation']);
        Route::delete('/conversations/{ulid}', [AssistantController::class, 'deleteConversation']);
        Route::get('/history', [AssistantController::class, 'getHistory']);
        Route::post('/clear-history', [AssistantController::class, 'clearHistory']);
    });
});

// Protected routes (v1)
Route::prefix('v1')->middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);
    Route::put('/user', [AuthController::class, 'update']);
    Route::put('/password', [AuthController::class, 'changePassword']);

    // Profile routes
    Route::post('/profile', [ProfileController::class, 'store']);
    Route::get('/profile', [ProfileController::class, 'show']);
    Route::put('/profile', [ProfileController::class, 'update']);

    // Settings routes
    Route::get('/settings', [SettingsController::class, 'show']);
    Route::put('/settings', [SettingsController::class, 'update']);
    Route::patch('/settings', [SettingsController::class, 'update']);

    // Favourites routes
    Route::get('/favourites', [FavouriteController::class, 'index']);
    Route::post('/favourites', [FavouriteController::class, 'store']);
    Route::delete('/favourites/{product_id}', [FavouriteController::class, 'destroy']);

    // History routes
    Route::get('/history', [HistoryController::class, 'index']);
    Route::post('/history', [HistoryController::class, 'store']);
});
