<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Documentation - Octopus</title>
    <script>
        // Detect base URL dynamically
        const API_BASE_URL = (function() {
            const hostname = window.location.hostname;
            const protocol = window.location.protocol;
            const pathname = window.location.pathname;

            // If accessing via ngrok
            if (hostname.includes('ngrok') || hostname.includes('ngrok-free.app')) {
                const currentUrl = window.location.origin;
                // Check if we're in /octopus subdirectory
                if (pathname.includes('/octopus')) {
                    return currentUrl + '/octopus/api/v1';
                }
                return currentUrl + '/api/v1';
            }

            // For localhost XAMPP setup
            if (hostname === 'localhost' || hostname === '127.0.0.1') {
                // Check if we're accessing via /octopus/public/
                if (pathname.includes('/octopus/public')) {
                    return 'http://localhost/octopus/public/api/v1';
                }
                // Check if we're accessing via /octopus/
                if (pathname.includes('/octopus')) {
                    return 'http://localhost/octopus/public/api/v1';
                }
                // Default XAMPP setup
                return 'http://localhost/octopus/public/api/v1';
            }

            // Default fallback
            return protocol + '//' + hostname + '/api/v1';
        })();
    </script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.6;
            color: #1f2937;
            background: #fff;
        }

        .layout {
            display: flex;
            min-height: 100vh;
        }

        .sidebar {
            width: 280px;
            background: #f9fafb;
            border-right: 1px solid #e5e7eb;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            padding: 0;
        }

        .sidebar-header {
            padding: 40px 24px 20px;
            border-bottom: 1px solid #e5e7eb;
        }

        .sidebar-header h1 {
            font-size: 1.5rem;
            font-weight: 700;
            color: #111827;
            margin-bottom: 8px;
        }

        .sidebar-header p {
            font-size: 0.875rem;
            color: #6b7280;
        }

        .base-url {
            background: #fff;
            padding: 8px 12px;
            border-radius: 4px;
            margin-top: 12px;
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, monospace;
            font-size: 0.75rem;
            color: #374151;
            display: block;
            border: 1px solid #e5e7eb;
        }

        .copy-btn {
            background: #4f46e5;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 0.7rem;
            font-weight: 500;
            transition: all 0.2s;
        }

        .copy-btn:hover {
            background: #4338ca;
        }

        .copy-btn.copied {
            background: #10b981;
        }

        .navigation {
            padding: 20px 0;
        }

        .nav-button {
            display: block;
            width: 100%;
            background: transparent;
            color: #4b5563;
            border: none;
            padding: 10px 24px;
            text-align: left;
            cursor: pointer;
            font-size: 0.875rem;
            font-weight: 500;
            transition: all 0.2s;
            border-left: 3px solid transparent;
        }

        .nav-button:hover {
            background: #f3f4f6;
            color: #111827;
        }

        .nav-button.active {
            background: #eff6ff;
            color: #4f46e5;
            border-left-color: #4f46e5;
        }

        .main-content {
            margin-left: 280px;
            flex: 1;
            padding: 0;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 60px 40px;
        }

        .section {
            display: none;
        }

        .section.active {
            display: block;
        }

        .section h2 {
            font-size: 1.875rem;
            font-weight: 600;
            color: #111827;
            margin-bottom: 24px;
            padding-bottom: 12px;
            border-bottom: 1px solid #e5e7eb;
        }

        .section h3 {
            font-size: 1.5rem;
            font-weight: 600;
            color: #111827;
            margin-top: 40px;
            margin-bottom: 16px;
        }

        .section p {
            color: #4b5563;
            margin-bottom: 16px;
        }

        .endpoint {
            background: #fff;
            border: 1px solid #e5e7eb;
            border-left: 4px solid #4f46e5;
            padding: 24px;
            margin-bottom: 24px;
            border-radius: 8px;
        }

        .endpoint-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 16px;
        }

        .method {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 4px;
            font-weight: 600;
            font-size: 0.75rem;
            text-transform: uppercase;
        }

        .method.post {
            background: #fef3c7;
            color: #92400e;
        }

        .method.get {
            background: #d1fae5;
            color: #065f46;
        }

        .method.put {
            background: #dbeafe;
            color: #1e40af;
        }

        .method.patch {
            background: #e0e7ff;
            color: #4338ca;
        }

        .method.delete {
            background: #fee2e2;
            color: #991b1b;
        }

        .endpoint-url {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, monospace;
            font-weight: 600;
            font-size: 1rem;
            color: #111827;
        }

        .auth-required {
            background: #fef2f2;
            color: #dc2626;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 0.75rem;
            font-weight: 500;
        }

        .auth-not-required {
            background: #eff6ff;
            color: #2563eb;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 0.75rem;
            font-weight: 500;
        }

        .endpoint-description {
            color: #6b7280;
            margin-bottom: 20px;
            font-size: 1rem;
        }

        .code-block {
            background: #1f2937;
            color: #f9fafb;
            padding: 16px;
            border-radius: 6px;
            overflow-x: auto;
            margin: 16px 0;
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, monospace;
            font-size: 0.875rem;
            line-height: 1.6;
        }

        .code-label {
            color: #374151;
            font-weight: 600;
            font-size: 0.875rem;
            margin-top: 20px;
            margin-bottom: 8px;
        }

        .field-rules {
            background: #f9fafb;
            padding: 16px;
            border-radius: 6px;
            margin: 16px 0;
            border: 1px solid #e5e7eb;
        }

        .field-rules h4 {
            margin-bottom: 12px;
            font-weight: 600;
            color: #111827;
            font-size: 0.875rem;
        }

        .field-rules ul {
            margin-left: 20px;
        }

        .field-rules li {
            margin-bottom: 6px;
            color: #4b5563;
            font-size: 0.875rem;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 24px 0;
        }

        .table th {
            background: #f9fafb;
            color: #111827;
            padding: 12px 16px;
            text-align: left;
            font-weight: 600;
            font-size: 0.875rem;
            border-bottom: 2px solid #e5e7eb;
        }

        .table td {
            padding: 12px 16px;
            border-bottom: 1px solid #e5e7eb;
            color: #4b5563;
            font-size: 0.875rem;
        }

        .table tr:last-child td {
            border-bottom: none;
        }

        .table tr:hover {
            background: #f9fafb;
        }

        .status-code {
            font-weight: 600;
            padding: 4px 10px;
            border-radius: 4px;
            display: inline-block;
            font-size: 0.75rem;
        }

        .status-200 {
            background: #d1fae5;
            color: #065f46;
        }

        .status-201 {
            background: #d1fae5;
            color: #065f46;
        }

        .status-401 {
            background: #fee2e2;
            color: #991b1b;
        }

        .status-422 {
            background: #fef3c7;
            color: #92400e;
        }

        .workflow {
            background: #eff6ff;
            padding: 20px;
            border-left: 4px solid #3b82f6;
            border-radius: 6px;
            margin: 20px 0;
        }

        .workflow h4 {
            color: #1e40af;
            margin-bottom: 12px;
            font-weight: 600;
            font-size: 1rem;
        }

        .workflow ol {
            margin-left: 20px;
        }

        .workflow li {
            margin-bottom: 8px;
            color: #1e40af;
        }

        .tip {
            background: #eff6ff;
            border-left: 4px solid #3b82f6;
            padding: 16px;
            border-radius: 6px;
            margin: 16px 0;
            color: #1e40af;
            font-size: 0.875rem;
        }

        .warning {
            background: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 16px;
            border-radius: 6px;
            margin: 16px 0;
            color: #92400e;
            font-size: 0.875rem;
        }

        footer {
            background: #fff;
            border-top: 1px solid #e5e7eb;
            padding: 40px 0;
            text-align: center;
            color: #6b7280;
            font-size: 0.875rem;
        }

        ul {
            margin: 16px 0;
            margin-left: 24px;
        }

        ul li {
            margin-bottom: 8px;
            color: #4b5563;
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
                position: relative;
                height: auto;
            }

            .main-content {
                margin-left: 0;
            }

            .container {
                padding: 40px 20px;
            }

            .sidebar-header {
                padding: 24px;
            }

            .table {
                font-size: 0.8rem;
            }

            .endpoint {
                padding: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="layout">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1>Octopus API Documentation</h1>
                <p>Two-Step Wizard: Authentication & Profile Management</p>
                <div class="base-url" id="baseUrlDisplay">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span style="color: #6b7280; font-size: 0.75rem; margin-bottom: 4px; display: block;">Base URL</span>
                        <button onclick="copyBaseUrl()" class="copy-btn" style="margin-left: 0; padding: 4px 8px; font-size: 0.7rem;">Copy</button>
                    </div>
                    <span id="baseUrlValue">Detecting...</span>
                </div>
            </div>

            <nav class="navigation">
                <button class="nav-button active" onclick="showSection('overview')">Overview</button>
                <button class="nav-button" onclick="showSection('home')">Home</button>
                <button class="nav-button" onclick="showSection('authentication')">Authentication</button>
                <button class="nav-button" onclick="showSection('profile')">Profile</button>
                <button class="nav-button" onclick="showSection('settings')">Settings</button>
                <button class="nav-button" onclick="showSection('categories')">Categories</button>
                <button class="nav-button" onclick="showSection('products')">Products</button>
                <button class="nav-button" onclick="showSection('advertisements')">Advertisements</button>
                <button class="nav-button" onclick="showSection('favourites')">Favourites</button>
                <button class="nav-button" onclick="showSection('assistant')">AI Assistant</button>
                <button class="nav-button" onclick="showSection('errors')">Errors</button>
                <button class="nav-button" onclick="showSection('examples')">Examples</button>
            </nav>
        </aside>

        <main class="main-content">
            <div class="container">
            <!-- Overview Section -->
            <div id="overview" class="section active">
                <h2>Overview</h2>

                <h3>API Summary</h3>
                <p>Complete REST API for a two-step user registration and profile setup wizard.</p>

                <table class="table">
                    <thead>
                        <tr>
                            <th>Method</th>
                            <th>Endpoint</th>
                            <th>Auth</th>
                            <th>Purpose</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/register</td>
                            <td>No</td>
                            <td>Create account</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/login</td>
                            <td>No</td>
                            <td>Get access token</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/home</td>
                            <td>No</td>
                            <td>Get home page data</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/user</td>
                            <td>Yes</td>
                            <td>Get user details</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/logout</td>
                            <td>Yes</td>
                            <td>Logout (revoke token)</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/forgot-password</td>
                            <td>No</td>
                            <td>Request password reset</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/reset-password</td>
                            <td>No</td>
                            <td>Reset password with token</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/profile</td>
                            <td>Yes</td>
                            <td>Create profile</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/profile</td>
                            <td>Yes</td>
                            <td>Get profile</td>
                        </tr>
                        <tr>
                            <td><span class="method put">PUT</span></td>
                            <td>/profile</td>
                            <td>Yes</td>
                            <td>Update profile</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/settings</td>
                            <td>Yes</td>
                            <td>Get user settings</td>
                        </tr>
                        <tr>
                            <td><span class="method put">PUT</span></td>
                            <td>/settings</td>
                            <td>Yes</td>
                            <td>Update all settings</td>
                        </tr>
                        <tr>
                            <td><span class="method put">PATCH</span></td>
                            <td>/settings</td>
                            <td>Yes</td>
                            <td>Partially update settings</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/categories</td>
                            <td>No</td>
                            <td>Get all categories</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/categories/{id}</td>
                            <td>No</td>
                            <td>Get category details</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/products</td>
                            <td>No</td>
                            <td>Get products (cursor/page pagination)</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/advertisements</td>
                            <td>Yes</td>
                            <td>Get targeted ads (for sliders)</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/advertisements/{id}</td>
                            <td>Yes</td>
                            <td>Get single ad details</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/favourites</td>
                            <td>Yes</td>
                            <td>Get user's favourite products</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/favourites</td>
                            <td>Yes</td>
                            <td>Add product to favourites</td>
                        </tr>
                        <tr>
                            <td><span class="method delete">DELETE</span></td>
                            <td>/favourites/{product_id}</td>
                            <td>Yes</td>
                            <td>Remove product from favourites</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/assistant/chat/free</td>
                            <td>No</td>
                            <td>AI assistant chat (guest access)</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/assistant/chat</td>
                            <td>Yes</td>
                            <td>AI assistant chat (authenticated)</td>
                        </tr>
                        <tr>
                            <td><span class="method post">POST</span></td>
                            <td>/assistant/stream</td>
                            <td>Yes</td>
                            <td>AI assistant streaming (SSE)</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/assistant/suggestions</td>
                            <td>No</td>
                            <td>Get AI conversation suggestions</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/assistant/conversations</td>
                            <td>Yes</td>
                            <td>List user conversations</td>
                        </tr>
                        <tr>
                            <td><span class="method get">GET</span></td>
                            <td>/assistant/conversations/{ulid}</td>
                            <td>Yes</td>
                            <td>Get conversation messages</td>
                        </tr>
                        <tr>
                            <td><span class="method delete">DELETE</span></td>
                            <td>/assistant/conversations/{ulid}</td>
                            <td>Yes</td>
                            <td>Delete conversation</td>
                        </tr>
                    </tbody>
                </table>

                <h3>Product Import Dashboard</h3>
                <p><strong>Dashboard URL:</strong> <code>/products/import</code></p>
                <p>Web-based dashboard to import products from Excel files (.xlsx, .xls, .csv).</p>
                <ul>
                    <li>Client-side Excel parsing using SheetJS library</li>
                    <li>Batch processing (50 products per request) for large files</li>
                    <li>Real-time progress indicator</li>
                    <li>Handles currency symbols (EGP, USD) and percentages automatically</li>
                    <li>Select category and source before importing</li>
                </ul>

                <h3>Two-Step Wizard Flow</h3>
                <div class="workflow">
                    <h4>Step 1: Authentication</h4>
                    <ol>
                        <li>User registers or logs in</li>
                        <li>Receives access token</li>
                        <li>Token stored in localStorage</li>
                    </ol>
                </div>

                <div class="workflow">
                    <h4>Step 2: Profile</h4>
                    <ol>
                        <li>User creates profile (gender required)</li>
                        <li>Can update profile anytime</li>
                        <li>Profile linked to user account</li>
                    </ol>
                </div>

                <h3>Status</h3>
                <p><strong>All endpoints tested and production-ready!</strong></p>
                <ul>
                    <li>38 Tests - 100% Passing</li>
                    <li>19 Endpoints - All Working</li>
                    <li>5 Controllers - Implemented</li>
                    <li>Complete Validation</li>
                    <li>AI Assistant with Tool Calling</li>
                </ul>
            </div>

            <!-- Home Section -->
            <div id="home" class="section">
                <h2>🏠 Home Route</h2>
                <p>Get all data needed for the home page in a single request. Returns main categories with their subcategories and products, plus targeted advertisements.</p>

                <!-- Get Home Data -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/home</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get home page data including categories with products and advertisements</div>

                    <div class="code-label">Features:</div>
                    <div class="field-rules">
                        <ul>
                            <li><strong>All Root Categories:</strong> Returns all parent categories (where parent_id is null)</li>
                            <li><strong>Subcategories Included:</strong> Each category includes its child categories</li>
                            <li><strong>Products Aggregation:</strong> Products from both parent category AND all its subcategories (max 8 per category)</li>
                            <li><strong>Targeted Ads:</strong> If authenticated, ads are filtered by user's gender and language preference</li>
                            <li><strong>Active Only:</strong> Only returns active categories and advertisements</li>
                            <li><strong>Single Request:</strong> Get all home page data in one API call</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "categories": [
    {
      "id": 1,
      "name_en": "Food",
      "name_ar": "الطعام",
      "slug": "food",
      "description_en": "Food and beverages",
      "description_ar": "الطعام والمشروبات",
      "image": "https://example.com/images/food.jpg",
      "icon": "<svg stroke=\"currentColor\" fill=\"none\" stroke-width=\"2\" viewBox=\"0 0 24 24\" stroke-linecap=\"round\" stroke-linejoin=\"round\" height=\"1em\" width=\"1em\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M3 2v7c0 1.1.9 2 2 2h4a2 2 0 0 0 2-2V2\"></path><path d=\"M7 2v20\"></path><path d=\"M21 15V2v0a5 5 0 0 0-5 5v6c0 1.1.9 2 2 2h3Zm0 0v7\"></path></svg>",
      "status": "active",
      "meta_title": "Food Category",
      "meta_description": "Shop for food and beverages",
      "subcategories": [
        {
          "id": 5,
          "name_en": "Beverages",
          "name_ar": "المشروبات",
          "slug": "beverages"
        },
        {
          "id": 8,
          "name_en": "Snacks",
          "name_ar": "الوجبات الخفيفة",
          "slug": "snacks"
        }
      ],
      "products": [
        {
          "id": 123,
          "name_en": "Organic Coffee",
          "name_ar": "قهوة عضوية",
          "image_url": "https://ae-pic-a1.aliexpress-media.com/...",
          "price": "25.99",
          "discount_price": "19.99",
          "currency": "USD"
        },
        {
          "id": 124,
          "name_en": "Green Tea",
          "name_ar": "شاي أخضر",
          "image_url": "https://ae-pic-a1.aliexpress-media.com/...",
          "price": "15.50",
          "discount_price": null,
          "currency": "USD"
        }
      ]
    },
    {
      "id": 2,
      "name_en": "Home Appliances",
      "name_ar": "الأجهزة المنزلية",
      "slug": "home-appliances",
      "description_en": "Home appliances and electronics",
      "description_ar": "الأجهزة المنزلية والإلكترونيات",
      "image": "https://example.com/images/appliances.jpg",
      "status": "active",
      "meta_title": "Home Appliances",
      "meta_description": "Shop home appliances",
      "subcategories": [],
      "products": [
        {
          "id": 201,
          "name_en": "Blender",
          "name_ar": "خلاط",
          "image_url": "https://ae-pic-a1.aliexpress-media.com/...",
          "price": "45.00",
          "discount_price": "35.00",
          "currency": "USD"
        }
      ]
    }
  ],
  "advertisements": [
    {
      "id": 1,
      "title": "Summer Sale",
      "title_ar": "تخفيضات الصيف",
      "image_url": "https://example.com/ads/summer-sale.jpg",
      "link": "https://example.com/promotions/summer"
    },
    {
      "id": 2,
      "title": "New Arrivals",
      "title_ar": "وصل حديثاً",
      "image_url": "https://example.com/ads/new-arrivals.jpg",
      "link": "https://example.com/new"
    }
  ]
}</div>

                    <div class="workflow">
                        <h4>How Products Are Aggregated:</h4>
                        <ol>
                            <li>For each root category, get its ID and all subcategory IDs</li>
                            <li>Query products where category_id is IN (parent_id, all child_ids)</li>
                            <li>Limit to 8 products per category (most recent first)</li>
                            <li>This ensures you get products from both the parent and its children</li>
                        </ol>
                    </div>

                    <div class="workflow">
                        <h4>Ad Targeting (When Authenticated):</h4>
                        <ul>
                            <li><strong>Male users:</strong> Sees ads targeting "male" or "all"</li>
                            <li><strong>Female users:</strong> Sees ads targeting "female" or "all"</li>
                            <li><strong>Arabic preference:</strong> Sees ads in "ar" or "both"</li>
                            <li><strong>English preference:</strong> Sees ads in "en" or "both"</li>
                            <li><strong>Guest users:</strong> Sees all active ads (no filtering)</li>
                        </ul>
                    </div>

                    <div class="tip">💡 Perfect for home page - get all categories, products, and ads in a single fast request!</div>
                    <div class="tip">🎯 Ads are automatically personalized based on user's profile when authenticated.</div>
                    <div class="tip">📱 Products are limited to 8 per category to keep response size manageable for mobile.</div>
                </div>
            </div>

            <!-- Authentication Section -->
            <div id="authentication" class="section">
                <h2>Authentication Routes</h2>

                <!-- Register -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method post">POST</span>
                        <span class="endpoint-url">/register</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Create a new user account with optional profile data</div>

                    <div class="code-label">Request Body (Basic):</div>
                    <div class="code-block">{
  "first_name": "John",
  "last_name": "Doe",
  "email": "john@example.com",
  "password": "password123",
  "password_confirmation": "password123"
}</div>

                    <div class="code-label">Request Body (With Profile - Optional):</div>
                    <div class="code-block">{
  "first_name": "John",
  "last_name": "Doe",
  "email": "john@example.com",
  "password": "password123",
  "password_confirmation": "password123",
  "gender": "male",
  "birth_date": "1990-01-15",
  "city": "New York",
  "interests": [1, 5, 13],
  "settings": {
    "notifications": true,
    "language": "en"
  }
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>first_name</strong> - required, string, max 255</li>
                            <li><strong>last_name</strong> - required, string, max 255</li>
                            <li><strong>email</strong> - optional, unique, email format</li>
                            <li><strong>phone</strong> - optional, unique, string</li>
                            <li><strong>password</strong> - required, min 8 chars, must confirm</li>
                            <li><strong>Either email OR phone is required</strong></li>
                            <li><strong>gender</strong> - optional, must be: male, female, or other</li>
                            <li><strong>birth_date</strong> - optional, YYYY-MM-DD format, must be past date</li>
                            <li><strong>city</strong> - optional, string, max 255</li>
                            <li><strong>interests</strong> - optional, array of category IDs</li>
                            <li><strong>settings</strong> - optional, JSON object</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (201 Created):</div>
                    <div class="code-block">{
  "user": {
    "id": 1,
    "first_name": "John",
    "last_name": "Doe",
    "email": "john@example.com",
    "phone": null,
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  },
  "access_token": "1|eyJ0eXAiOiJKV1QiLCJhbGc...",
  "token_type": "Bearer",
  "expires_at": null
}</div>
                    <div class="tip">Save the access_token - you'll need it for Step 2!</div>
                </div>

                <!-- Login -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method post">POST</span>
                        <span class="endpoint-url">/login</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Authenticate user and get access token</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "username": "john@example.com",
  "password": "password123"
}</div>

                    <div class="field-rules">
                        <h4>Notes:</h4>
                        <ul>
                            <li><strong>username</strong> can be email or phone</li>
                            <li>Both <strong>username</strong> and <strong>password</strong> are required</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "user": { ... },
  "access_token": "1|eyJ0eXAiOiJKV1QiLCJhbGc...",
  "token_type": "Bearer",
  "expires_at": null
}</div>
                </div>

                <!-- Get User -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/user</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Get authenticated user details</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "id": 1,
    "first_name": "John",
    "last_name": "Doe",
    "email": "john@example.com",
    "phone": null,
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  }
}</div>
                </div>

                <!-- Update User -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method put">PUT</span>
                        <span class="endpoint-url">/user</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Update user information (name, email, phone)</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "first_name": "John",
  "last_name": "Doe",
  "email": "john.doe@example.com",
  "phone": "+1234567890"
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>first_name</strong> - required, string, max 255</li>
                            <li><strong>last_name</strong> - required, string, max 255</li>
                            <li><strong>email</strong> - optional, unique, email format</li>
                            <li><strong>phone</strong> - optional, unique, string</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "id": 1,
    "first_name": "John",
    "last_name": "Doe",
    "email": "john.doe@example.com",
    "phone": "+1234567890",
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T14:30:00Z"
  }
}</div>

                    <div class="workflow">
                        <h4>Email/Phone Change Behavior:</h4>
                        <ul>
                            <li><strong>Email changed:</strong> <code>email_verified_at</code> is set to null, verification email sent</li>
                            <li><strong>Phone changed:</strong> <code>email_verified_at</code> is set to null, verification code logged (TODO: SMS)</li>
                        </ul>
                    </div>
                </div>

                <!-- Change Password -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method put">PUT</span>
                        <span class="endpoint-url">/password</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Change user password (requires current password)</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "current_password": "oldpassword123",
  "password": "newpassword456",
  "password_confirmation": "newpassword456"
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>current_password</strong> - required, must match user's current password</li>
                            <li><strong>password</strong> - required, min 8 characters, must match password_confirmation</li>
                            <li><strong>password_confirmation</strong> - required</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "message": "Password changed successfully."
}</div>

                    <div class="code-label">Response (401 Unauthorized):</div>
                    <div class="code-block">{
  "message": "The current password is incorrect."
}</div>

                    <div class="tip">User remains logged in after password change. Current session is not revoked.</div>
                </div>

                <!-- Logout -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method post">POST</span>
                        <span class="endpoint-url">/logout</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Logout and revoke access token</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "message": "Logged out successfully"
}</div>
                    <div class="tip">Token is revoked on server. Remove from localStorage to complete logout.</div>
                </div>

                <!-- Forgot Password -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method post">POST</span>
                        <span class="endpoint-url">/forgot-password</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Request a password reset code or link</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "username": "john@example.com"
}</div>
                    <div class="code-block">{
  "username": "1234567890"
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>username</strong> - required, can be email or phone number</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "message": "If an account exists with this email or phone, a password reset code has been sent."
}</div>

                    <div class="workflow">
                        <h4>How It Works:</h4>
                        <ul>
                            <li><strong>Email users:</strong> Receive a password reset link via email</li>
                            <li><strong>Phone-only users:</strong> Receive a 6-digit code (currently logged to storage/logs/laravel.log for testing)</li>
                            <li><strong>Token expiration:</strong> Codes/links expire after 60 minutes</li>
                            <li><strong>Security:</strong> Always returns success message to prevent username enumeration</li>
                        </ul>
                    </div>
                    <div class="warning">⚠️ Rate limited: 5 requests per minute per IP</div>
                </div>

                <!-- Reset Password -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method post">POST</span>
                        <span class="endpoint-url">/reset-password</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Reset password with token/code from forgot-password</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "username": "john@example.com",
  "token": "reset_token_or_6digit_code",
  "password": "newpassword123",
  "password_confirmation": "newpassword123"
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>username</strong> - required, email or phone number used in forgot-password request</li>
                            <li><strong>token</strong> - required, the token/link from email or 6-digit code</li>
                            <li><strong>password</strong> - required, min 8 characters, must match password_confirmation</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "message": "Password has been reset successfully. Please login with your new password."
}</div>

                    <div class="code-label">Response (400 Bad Request):</div>
                    <div class="code-block">{
  "message": "Invalid or expired reset token."
}</div>

                    <div class="workflow">
                        <h4>What Happens After Reset:</h4>
                        <ul>
                            <li><strong>All Sanctum tokens revoked:</strong> User is logged out from all devices</li>
                            <li><strong>Must re-login:</strong> User needs to login again with new password</li>
                            <li><strong>Token consumed:</strong> Reset token can only be used once</li>
                        </ul>
                    </div>
                    <div class="warning">⚠️ Rate limited: 5 requests per minute per IP</div>
                </div>
            </div>

            <!-- Profile Section -->
            <div id="profile" class="section">
                <h2>Profile Routes</h2>

                <!-- Create Profile -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method post">POST</span>
                        <span class="endpoint-url">/profile</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Create user profile (Step 2 of wizard)</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "gender": "male",
  "birth_date": "1990-01-15",
  "city": "New York",
  "interests": ["coding", "reading", "travel"],
  "settings": {
    "notifications": true,
    "email_digest": "weekly"
  }
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>gender</strong> - required, must be: male, female, or other</li>
                            <li><strong>birth_date</strong> - optional, YYYY-MM-DD format, must be past date</li>
                            <li><strong>city</strong> - optional, string, max 255 chars</li>
                            <li><strong>interests</strong> - optional, array of strings</li>
                            <li><strong>settings</strong> - optional, JSON object</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (201 Created):</div>
                    <div class="code-block">{
  "data": {
    "id": 1,
    "user_id": 1,
    "gender": "male",
    "birth_date": "1990-01-15",
    "city": "New York",
    "interests": ["coding", "reading", "travel"],
    "settings": { "notifications": true },
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  }
}</div>
                    <div class="warning">Gender is required! Must be exactly: male, female, or other</div>
                </div>

                <!-- Get Profile -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/profile</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Get authenticated user's profile</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "id": 1,
    "user_id": 1,
    "gender": "male",
    "birth_date": "1990-01-15",
    "city": "New York",
    "interests": ["coding", "reading", "travel"],
    "settings": { "notifications": true },
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  }
}</div>
                </div>

                <!-- Update Profile -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method put">PUT</span>
                        <span class="endpoint-url">/profile</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Update authenticated user's profile</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "gender": "female",
  "birth_date": "1995-06-20",
  "city": "Los Angeles",
  "interests": ["music", "travel", "fitness"],
  "settings": {
    "notifications": false,
    "email_digest": "monthly"
  }
}</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "id": 1,
    "user_id": 1,
    "gender": "female",
    "birth_date": "1995-06-20",
    "city": "Los Angeles",
    "interests": ["music", "travel", "fitness"],
    "settings": { "notifications": false },
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  }
}</div>
                </div>
            </div>

            <!-- Settings Section -->
            <div id="settings" class="section">
                <h2>⚙️ Settings Routes</h2>
                <p>Manage user preferences including language, UI theme, and notification settings. Settings are stored per-user in the profile.</p>

                <!-- Get Settings -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/settings</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Get current user's settings with defaults applied</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "language": "en",
    "ui_mode": "system",
    "notifications": {
      "push_enabled": true
    }
  }
}</div>
                    <div class="tip">💡 Default values are returned even if user hasn't set preferences yet!</div>
                </div>

                <!-- Update All Settings (PUT) -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method put">PUT</span>
                        <span class="endpoint-url">/settings</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Update all settings (full replacement)</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "language": "ar",
  "ui_mode": "dark",
  "notifications": {
    "push_enabled": false
  }
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>language</strong> - optional, must be: en or ar</li>
                            <li><strong>ui_mode</strong> - optional, must be: light, dark, or system</li>
                            <li><strong>notifications</strong> - optional, object with boolean flag</li>
                            <li><strong>notifications.push_enabled</strong> - optional, boolean (enable/disable push notifications)</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "language": "ar",
    "ui_mode": "dark",
    "notifications": {
      "email_enabled": true,
      "push_enabled": false,
      "order_updates": true,
      "promotional": false
    }
  }
}</div>
                    <div class="warning">⚠️ Profile must be created before updating settings!</div>
                </div>

                <!-- Partial Update (PATCH) -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method patch">PATCH</span>
                        <span class="endpoint-url">/settings</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Partially update settings - only specified fields are updated</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Request Body (Change only theme):</div>
                    <div class="code-block">{
  "ui_mode": "light"
}</div>

                    <div class="code-label">Request Body (Toggle push notifications):</div>
                    <div class="code-block">{
  "notifications": {
    "push_enabled": false
  }
}</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "language": "en",
    "ui_mode": "light",
    "notifications": {
      "push_enabled": false
    }
  }
}</div>
                    <div class="tip">✨ Perfect for changing a single setting without affecting others!</div>
                </div>

                <h3 style="color: #667eea; margin-top: 30px;">Settings Details</h3>

                <div class="field-rules">
                    <h4>Language Options:</h4>
                    <ul>
                        <li><strong>en</strong> - English (default)</li>
                        <li><strong>ar</strong> - Arabic</li>
                    </ul>
                </div>

                <div class="field-rules">
                    <h4>UI Mode Options:</h4>
                    <ul>
                        <li><strong>light</strong> - Light theme</li>
                        <li><strong>dark</strong> - Dark theme</li>
                        <li><strong>system</strong> - Follow system preferences (default)</li>
                    </ul>
                </div>

                <div class="field-rules">
                    <h4>Notification Flags:</h4>
                    <ul>
                        <li><strong>push_enabled</strong> - Enable/disable push notifications (default: true)</li>
                    </ul>
                </div>

                <div class="workflow">
                    <h4>Common Use Cases</h4>
                    <ol>
                        <li><strong>Theme Switcher:</strong> Use PATCH with just "ui_mode" to toggle theme</li>
                        <li><strong>Language Selector:</strong> Use PATCH with just "language" to change language</li>
                        <li><strong>Push Notifications Toggle:</strong> Use PATCH with "notifications.push_enabled" to toggle push notifications</li>
                        <li><strong>Settings Page:</strong> Use PUT to save complete settings form</li>
                    </ol>
                </div>
            </div>

            <!-- Categories Section -->
            <div id="categories" class="section">
                <h2>🏷️ Categories Routes</h2>

                <!-- List Categories -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/categories</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get all product categories</div>

                    <div class="code-label">Query Parameters:</div>
                    <div class="field-rules">
                        <ul>
                            <li><strong>page</strong> - optional, page number (default: 1)</li>
                            <li><strong>per_page</strong> - optional, items per page (default: 15)</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": [
    {
      "id": 1,
      "parent_id": null,
      "name_ar": "الطعام",
      "name_en": "Food",
      "slug": "food",
      "description_ar": null,
      "description_en": null,
      "image": null,
      "status": "active",
      "position": 1,
      "meta_title": null,
      "meta_description": null,
      "created_at": "2026-01-25T12:00:00Z",
      "updated_at": "2026-01-25T12:00:00Z"
    },
    {
      "id": 2,
      "parent_id": null,
      "name_ar": "الأجهزة المنزلية",
      "name_en": "Home Appliances",
      "slug": "home-appliances",
      "description_ar": null,
      "description_en": null,
      "image": null,
      "status": "active",
      "position": 2,
      "meta_title": null,
      "meta_description": null,
      "created_at": "2026-01-25T12:00:00Z",
      "updated_at": "2026-01-25T12:00:00Z"
    }
    // ... more categories
  ],
  "links": {
    "first": "http://localhost:8000/api/v1/categories?page=1",
    "last": "http://localhost:8000/api/v1/categories?page=3",
    "prev": null,
    "next": "http://localhost:8000/api/v1/categories?page=2"
  },
  "meta": {
    "current_page": 1,
    "from": 1,
    "last_page": 3,
    "per_page": 15,
    "to": 15,
    "total": 36
  }
}</div>

                    <div class="code-label">Example Requests:</div>
                    <div class="code-block">GET /categories                    (page 1, 15 items)
GET /categories?page=2            (page 2, 15 items)
GET /categories?per_page=10       (page 1, 10 items)
GET /categories?page=2&per_page=20  (page 2, 20 items)</div>
                </div>

                <!-- Get Single Category -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/categories/{id}</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get specific category details</div>

                    <div class="code-label">URL Parameters:</div>
                    <div class="field-rules">
                        <ul>
                            <li><strong>id</strong> - required, category ID (1-36)</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": {
    "id": 1,
    "parent_id": null,
    "name_ar": "الطعام",
    "name_en": "Food",
    "slug": "food",
    "description_ar": null,
    "description_en": null,
    "image": null,
    "status": "active",
    "position": 1,
    "meta_title": null,
    "meta_description": null,
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  }
}</div>
                </div>

                <h3 style="color: #667eea; margin-top: 30px;">Available Categories (36 Total)</h3>
                <div class="field-rules">
                    <p style="margin-bottom: 15px;">All categories support both English and Arabic names:</p>
                    <ul style="columns: 2; column-gap: 30px;">
                        <li>Food</li>
                        <li>Home Appliances</li>
                        <li>Computer & Office</li>
                        <li>Home Improvement</li>
                        <li>Home & Garden</li>
                        <li>Sports & Entertainment</li>
                        <li>Office & School Supplies</li>
                        <li>Toys & Hobbies</li>
                        <li>Security & Protection</li>
                        <li>Automobiles, Parts & Accessories</li>
                        <li>Jewelry & Accessories</li>
                        <li>Lights & Lighting</li>
                        <li>Consumer Electronics</li>
                        <li>Beauty & Health</li>
                        <li>Weddings & Events</li>
                        <li>Shoes</li>
                        <li>Electronic Components & Supplies</li>
                        <li>Phones & Telecommunications</li>
                        <li>Tools</li>
                        <li>Mother & Kids</li>
                        <li>Furniture</li>
                        <li>Watches</li>
                        <li>Luggage & Bags</li>
                        <li>Underwear</li>
                        <li>Virtual Products</li>
                        <li>Industrial & Business</li>
                        <li>Sports Shoes, Clothing & Accessories</li>
                        <li>Phones & Telecommunications Accessories</li>
                        <li>Women's Clothing</li>
                        <li>Men's Clothing</li>
                        <li>Apparel Accessories</li>
                        <li>Hair Extensions & Wigs</li>
                        <li>Special Category</li>
                        <li>Books & Cultural Merchandise</li>
                        <li>Novelty & Special Use</li>
                        <li>Motorcycle Equipments & Parts</li>
                    </ul>
                </div>

                <div class="tip">💡 Categories support hierarchical structure via parent_id field for subcategories</div>

                <h3 style="color: #667eea; margin-top: 30px;">Hierarchical Categories (Parent/Child)</h3>

                <!-- List Root Categories Only -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/categories?only_parents=true</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get only root categories (categories without a parent)</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": [
    {
      "id": 1,
      "parent_id": null,
      "name_ar": "إلكترونيات",
      "name_en": "Electronics",
      "slug": "electronics",
      "description_ar": "أجهزة إلكترونية",
      "description_en": "Electronic devices",
      "image": "https://example.com/images/electronics.jpg",
      "icon": "<svg stroke=\"currentColor\" fill=\"none\" stroke-width=\"2\" viewBox=\"0 0 24 24\" stroke-linecap=\"round\" stroke-linejoin=\"round\" height=\"1em\" width=\"1em\" xmlns=\"http://www.w3.org/2000/svg\"><rect x=\"2\" y=\"3\" width=\"20\" height=\"14\" rx=\"2\" ry=\"2\"></rect><line x1=\"8\" y1=\"21\" x2=\"16\" y2=\"21\"></line><line x1=\"12\" y1=\"17\" x2=\"12\" y2=\"21\"></line></svg>",
      "status": "active",
      "position": 1,
      "meta_title": "Electronics Category",
      "meta_description": "Shop electronic devices",
      "parent": null,
      "children": [
        {
          "id": 2,
          "parent_id": 1,
          "name_ar": "هواتف",
          "name_en": "Phones",
          "slug": "phones",
          ...
        }
      ],
      "children_count": 5,
      "created_at": "2026-01-25T12:00:00Z",
      "updated_at": "2026-01-25T12:00:00Z"
    }
  ]
}</div>
                </div>

                <!-- Filter by Parent ID -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/categories?parent_id={id}</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get all subcategories of a specific parent category</div>

                    <div class="code-label">URL Parameters:</div>
                    <div class="field-rules">
                        <ul>
                            <li><strong>parent_id</strong> - parent category ID (use "null" or "" for root categories)</li>
                        </ul>
                    </div>

                    <div class="code-label">Example Requests:</div>
                    <div class="code-block">GET /categories?parent_id=1        (Get subcategories of category 1)
GET /categories?parent_id=null     (Get root categories)</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": [
    {
      "id": 2,
      "parent_id": 1,
      "name_ar": "هواتف",
      "name_en": "Phones",
      "slug": "phones",
      "description_ar": "هواتف ذكية",
      "description_en": "Smartphones",
      "image": "https://example.com/images/phones.jpg",
      "icon": "<svg stroke=\"currentColor\" fill=\"none\" stroke-width=\"2\" viewBox=\"0 0 24 24\" stroke-linecap=\"round\" stroke-linejoin=\"round\" height=\"1em\" width=\"1em\" xmlns=\"http://www.w3.org/2000/svg\"><rect x=\"5\" y=\"2\" width=\"14\" height=\"20\" rx=\"2\" ry=\"2\"></rect><line x1=\"12\" y1=\"18\" x2=\"12.01\" y2=\"18\"></line></svg>",
      "status": "active",
      "position": 1,
      "meta_title": "Phones",
      "meta_description": "Shop smartphones",
      "parent": {
        "id": 1,
        "name_ar": "إلكترونيات",
        "name_en": "Electronics",
        "slug": "electronics"
      },
      "children": [],
      "children_count": 0,
      "created_at": "2026-01-25T12:00:00Z",
      "updated_at": "2026-01-25T12:00:00Z"
    }
  ]
}</div>
                </div>

                <h3 style="color: #667eea; margin-top: 30px;">Category Response Fields</h3>
                <div class="field-rules">
                    <h4>Additional Fields in Category Response:</h4>
                    <ul>
                        <li><strong>icon</strong> - SVG icon string (ready to render as HTML) - contains inline SVG with stroke/fill attributes</li>
                        <li><strong>parent</strong> - Parent category info (id, name_ar, name_en, slug) - only when category has a parent</li>
                        <li><strong>children</strong> - Array of child categories - only when loaded with relationships</li>
                        <li><strong>children_count</strong> - Number of direct child categories</li>
                    </ul>
                </div>

                <h3 style="color: #667eea; margin-top: 30px;">Building a Category Tree (JavaScript Example)</h3>
                <div class="code-label">Fetch and Display Category Navigation:</div>
                <div class="code-block">async function buildCategoryTree() {
  const response = await fetch('http://localhost/api/v1/categories?only_parents=true');
  const data = await response.json();
  const rootCategories = data.data;

  const menu = document.getElementById('category-menu');

  rootCategories.forEach(category => {
    const categoryDiv = document.createElement('div');
    categoryDiv.innerHTML = `
      <div class="category-item">
        <a href="/category/${category.slug}">${category.name_en}</a>
        ${category.children_count > 0 ? `<span class="badge">${category.children_count}</span>` : ''}
      </div>
    `;

    if (category.children && category.children.length > 0) {
      const subcategoryList = document.createElement('ul');
      category.children.forEach(child => {
        const li = document.createElement('li');
        li.innerHTML = `<a href="/category/${child.slug}">${child.name_en}</a>`;
        subcategoryList.appendChild(li);
      });
      categoryDiv.appendChild(subcategoryList);
    }

    menu.appendChild(categoryDiv);
  });
}</div>

                <h3 style="color: #667eea; margin-top: 30px;">React Component Example</h3>
                <div class="code-block">import { useState, useEffect } from 'react';

export function CategoryTree() {
  const [categories, setCategories] = useState([]);

  useEffect(() => {
    fetchCategories();
  }, []);

  const fetchCategories = async () => {
    const response = await fetch('/api/v1/categories?only_parents=true');
    const data = await response.json();
    setCategories(data.data);
  };

  const CategoryItem = ({ category }) => (
    <div className="category-item">
      <a href={`/category/${category.slug}`}>
        {category.name_en}
        {category.children_count > 0 && (
          <span className="badge">{category.children_count}</span>
        )}
      </a>

      {category.children && category.children.length > 0 && (
        <ul className="subcategories">
          {category.children.map(child => (
            <li key={child.id}>
              <CategoryItem category={child} />
            </li>
          ))}
        </ul>
      )}
    </div>
  );

  return (
    <nav className="category-nav">
      {categories.map(category => (
        <CategoryItem key={category.id} category={category} />
      ))}
    </nav>
  );
}</div>
            </div>

            <!-- Products Section -->
            <div id="products" class="section">
                <h2>📦 Products Routes</h2>

                <!-- List Products -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/products</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get products with cursor-based pagination for infinite scroll or traditional page-based pagination</div>

                    <div class="code-label">Query Parameters:</div>
                    <div class="field-rules">
                        <ul>
                            <li><strong>pagination</strong> - optional, "cursor" (default) or "page"</li>
                            <li><strong>cursor</strong> - optional, cursor token from previous response (for infinite scroll)</li>
                            <li><strong>page</strong> - optional, page number (for traditional pagination)</li>
                            <li><strong>per_page</strong> - optional, items per page (default: 15)</li>
                            <li><strong>category_id</strong> - optional, filter by category ID</li>
                            <li><strong>min_price</strong> - optional, minimum price filter</li>
                            <li><strong>max_price</strong> - optional, maximum price filter</li>
                            <li><strong>search</strong> - optional, search in product names (Arabic & English)</li>
                            <li><strong>sort_by</strong> - optional, sort field: "price", "discount_price", "clicks", "sales_180day", "positive_feedback"</li>
                            <li><strong>sort_direction</strong> - optional, "asc" or "desc" (default: asc)</li>
                        </ul>
                    </div>

                    <div class="code-label">Response - Cursor Pagination (200 OK):</div>
                    <div class="code-block">{
  "data": [
    {
      "id": 1,
      "product_id": "1005010479585647",
      "category_id": 13,
      "category": {
        "id": 13,
        "name_ar": "الإلكترونيات الاستهلاكية",
        "name_en": "Consumer Electronics"
      },
      "source": "aliexpress",
      "image_url": "https://ae-pic-a1.aliexpress-media.com/kf/S11f5b9e32964467a9f14878c3c289501N.jpg",
      "video_url": null,
      "name_ar": "لابتوب جيمنج",
      "name_en": "Gaming Laptop",
      "description_ar": "وصف المنتج بالعربي...",
      "description_en": "Product description in English...",
      "price": "834.57",
      "discount_price": "632.24",
      "discount": "24.00",
      "currency": "EGP",
      "clicks": 205,
      "direct_commission_rate": "9.00",
      "estimated_direct_commission": "56.90",
      "indirect_commission_rate": "9.00",
      "estimated_indirect_commission": "56.90",
      "sales_180day": 205,
      "positive_feedback": "98.00",
      "promotion_url": "https://s.click.aliexpress.com/e/_c3HznrEX",
      "code_name": "I6KNOFT2GOGZ",
      "code_start_time": "2026-01-12T00:00:00Z",
      "code_end_time": "2026-01-19T23:59:59Z",
      "code_value": "60.56",
      "code_quantity": 187,
      "code_minimum_spend": "60.64",
      "created_at": "2026-01-27T10:00:00Z",
      "updated_at": "2026-01-27T10:00:00Z"
    }
  ],
  "path": "http://localhost/octopus/public/api/v1/products",
  "per_page": 15,
  "next_cursor": "eyJpZCI6MTUsIl9wb2ludHNUb05leHRJdGVtcyI6dHJ1ZX0",
  "next_page_url": "http://localhost/octopus/public/api/v1/products?cursor=eyJpZCI6MTUsIl9wb2ludHNUb05leHRJdGVtcyI6dHJ1ZX0&per_page=15",
  "prev_cursor": null,
  "prev_page_url": null
}</div>

                    <div class="code-label">Response - Page Pagination (200 OK):</div>
                    <div class="code-block">{
  "data": [...],
  "links": {
    "first": "http://localhost/octopus/public/api/v1/products?page=1",
    "last": "http://localhost/octopus/public/api/v1/products?page=10",
    "prev": null,
    "next": "http://localhost/octopus/public/api/v1/products?page=2"
  },
  "meta": {
    "current_page": 1,
    "from": 1,
    "last_page": 10,
    "per_page": 15,
    "to": 15,
    "total": 150
  }
}</div>
                </div>

                <h3>🔄 Infinite Scroll Implementation</h3>

                <div class="code-label">JavaScript Example:</div>
                <div class="code-block">let nextCursor = null;
let loading = false;

async function loadProducts() {
  if (loading) return;
  loading = true;

  const url = new URL('http://localhost/octopus/public/api/v1/products');
  url.searchParams.set('per_page', '20');
  if (nextCursor) {
    url.searchParams.set('cursor', nextCursor);
  }

  try {
    const response = await fetch(url);
    const data = await response.json();

    // Append products to UI
    data.data.forEach(product => {
      appendProductToUI(product);
    });

    // Update cursor for next load
    nextCursor = data.next_cursor;

    // If no next cursor, we've reached the end
    if (!nextCursor) {
      disableLoadMore();
    }
  } finally {
    loading = false;
  }
}

// Detect scroll near bottom
window.addEventListener('scroll', () => {
  if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 500) {
    loadProducts();
  }
});

// Initial load
loadProducts();</div>

                <div class="code-label">React Hook Example:</div>
                <div class="code-block">import { useState, useEffect } from 'react';

function useInfiniteProducts(filters = {}) {
  const [products, setProducts] = useState([]);
  const [cursor, setCursor] = useState(null);
  const [hasMore, setHasMore] = useState(true);
  const [loading, setLoading] = useState(false);

  const loadMore = async () => {
    if (loading || !hasMore) return;

    setLoading(true);
    const params = new URLSearchParams({
      per_page: '20',
      ...filters,
      ...(cursor && { cursor })
    });

    const response = await fetch(`/api/v1/products?${params}`);
    const data = await response.json();

    setProducts(prev => [...prev, ...data.data]);
    setCursor(data.next_cursor);
    setHasMore(!!data.next_cursor);
    setLoading(false);
  };

  return { products, loadMore, hasMore, loading };
}</div>

                <h3>🔍 Filtering Examples</h3>

                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/products?category_id=13</span>
                    </div>
                    <div class="endpoint-description">Filter by category</div>
                </div>

                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/products?min_price=100&max_price=500</span>
                    </div>
                    <div class="endpoint-description">Filter by price range</div>
                </div>

                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/products?search=laptop</span>
                    </div>
                    <div class="endpoint-description">Search products by name (Arabic & English)</div>
                </div>

                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/products?sort_by=price&sort_direction=asc</span>
                    </div>
                    <div class="endpoint-description">Sort products by price (ascending)</div>
                </div>

                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/products?category_id=13&min_price=50&max_price=200&sort_by=sales_180day&sort_direction=desc</span>
                    </div>
                    <div class="endpoint-description">Combined filters: category + price range + sort by sales</div>
                </div>

                <div class="tip">💡 Cursor pagination is the default and recommended for infinite scroll. Use pagination=page for traditional pagination.</div>
                <div class="tip">🔗 All filters work seamlessly with both cursor and page-based pagination.</div>
                <div class="tip">📊 Products table is currently empty - will be populated via Excel upload feature.</div>
            </div>

            <!-- Advertisements Section -->
            <div id="advertisements" class="section">
                <h2>📢 Advertisements Routes</h2>
                <p>Get personalized advertisements for slider display. Ads are automatically filtered based on user's profile (gender and language preference).</p>

                <!-- List Advertisements -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/advertisements</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get personalized advertisements for slider display. Ads are automatically filtered based on user's profile (gender and language preference) and only returns active ads within their date range.</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE</div>

                    <div class="code-label">How Targeting Works:</div>
                    <div class="field-rules">
                        <h4>Automatic Filtering:</h4>
                        <ul>
                            <li><strong>Gender Targeting:</strong> If user's profile gender is <code>male</code>, returns ads targeting <code>male</code> or <code>all</code>. If <code>female</code>, returns ads targeting <code>female</code> or <code>all</code>.</li>
                            <li><strong>Language Targeting:</strong> If user's profile settings language is <code>ar</code>, returns ads in <code>ar</code> or <code>both</code>. If <code>en</code>, returns ads in <code>en</code> or <code>both</code>.</li>
                            <li><strong>Active Only:</strong> Only returns ads with <code>status=active</code> and within valid date range (<code>start_date &lt;= today &lt;= end_date</code>, or null dates).</li>
                            <li><strong>Sorted By:</strong> Returns ads sorted by <code>sort_order</code> (ASC), then <code>created_at</code> (DESC).</li>
                            <li><strong>No Pagination:</strong> Returns all matching ads - perfect for sliders!</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">[
  {
    "id": 1,
    "title_ar": "عرض خاص",
    "title_en": "Special Offer",
    "image": "https://example.com/images/ad1.jpg",
    "url": "https://example.com/promo1",
    "status": "active",
    "start_date": "2026-01-01",
    "end_date": "2026-12-31",
    "sort_order": 1,
    "targeted_audience": "all",
    "targeted_language": "both",
    "created_at": "2026-01-25T12:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  },
  {
    "id": 2,
    "title_ar": "عرض للرجال",
    "title_en": "Men's Offer",
    "image": "https://example.com/images/ad2.jpg",
    "url": "https://example.com/promo2",
    "status": "active",
    "start_date": "2026-01-15",
    "end_date": null,
    "sort_order": 2,
    "targeted_audience": "male",
    "targeted_language": "both",
    "created_at": "2026-01-20T10:00:00Z",
    "updated_at": "2026-01-25T12:00:00Z"
  }
]</div>

                    <div class="code-label">JavaScript Example (Slider):</div>
                    <div class="code-block">async function loadAdvertisements() {
  const token = localStorage.getItem('access_token');
  const response = await fetch('http://localhost/api/v1/advertisements', {
    method: 'GET',
    headers: {
      'Authorization': `Bearer ${token}`
    }
  });

  if (response.ok) {
    const ads = await response.json();

    // Display in slider - all ads are already filtered and sorted
    if (ads.length > 0) {
      displaySlider(ads);
    } else {
      // Hide slider if no ads
      document.getElementById('ad-slider').style.display = 'none';
    }
  }
}

// Example slider implementation
function displaySlider(ads) {
  const sliderContainer = document.getElementById('ad-slider');

  sliderContainer.innerHTML = ads.map(ad => `
    <div class="slide" data-url="${ad.url}">
      <img src="${ad.image}" alt="${ad.title_en}">
      <div class="slide-content">
        <h3>${ad.title_en}</h3>
      </div>
    </div>
  `).join('');

  // Initialize your slider library (Swiper, Slick, etc.)
  initSlider(sliderContainer);
}</div>
                </div>

                <!-- Get Single Advertisement -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/advertisements/{id}</span>
                        <span class="auth-not-required">No Auth</span>
                    </div>
                    <div class="endpoint-description">Get a single advertisement by ID</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "id": 1,
  "title_ar": "عرض خاص",
  "title_en": "Special Offer",
  "image": "https://example.com/images/ad1.jpg",
  "url": "https://example.com/promo1",
  "status": "active",
  "start_date": "2026-01-01",
  "end_date": "2026-12-31",
  "sort_order": 1,
  "targeted_audience": "all",
  "targeted_language": "both",
  "created_at": "2026-01-25T12:00:00Z",
  "updated_at": "2026-01-25T12:00:00Z"
}</div>
                </div>

                <div class="tip">💡 Advertisements are automatically filtered based on user profile - no need to pass any parameters!</div>
                <div class="tip">🎯 Perfect for sliders: all matching ads are returned at once, no pagination needed.</div>
                <div class="tip">🌍 Supports both Arabic and English ads with automatic language filtering.</div>
            </div>

            <!-- Favourites Section -->
            <div id="favourites" class="section">
                <h2>❤️ Favourites Routes</h2>
                <p>Manage user's favourite products. Users can add/remove products from their favourites list and view all favourited products with pagination.</p>

                <!-- List Favourites -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method get">GET</span>
                        <span class="endpoint-url">/favourites</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Get authenticated user's favourite products with pagination</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE</div>

                    <div class="code-label">Query Parameters:</div>
                    <div class="field-rules">
                        <ul>
                            <li><strong>per_page</strong> - optional, items per page (default: 15)</li>
                        </ul>
                    </div>

                    <div class="code-label">Example Requests:</div>
                    <div class="code-block">GET /favourites                   (page 1, 15 items)
GET /favourites?per_page=10         (page 1, 10 items)
GET /favourites?page=2&per_page=20  (page 2, 20 items)</div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "data": [
    {
      "id": 1,
      "user_id": 1,
      "product_id": 5,
      "product": {
        "id": 5,
        "product_id": "1005010479585647",
        "category_id": 13,
        "category": {
          "id": 13,
          "name_ar": "الإلكترونيات الاستهلاكية",
          "name_en": "Consumer Electronics"
        },
        "source": "aliexpress",
        "image_url": "https://example.com/image.jpg",
        "name_ar": "لابتوب...",
        "name_en": "Gaming Laptop...",
        "price": "834.57",
        "discount_price": "632.24",
        "discount": "24.00",
        "currency": "EGP",
        "clicks": 205,
        "sales_180day": 205,
        "positive_feedback": "98.00",
        "created_at": "2026-01-27T10:00:00Z",
        "updated_at": "2026-01-27T10:00:00Z"
      },
      "created_at": "2026-01-28T12:00:00Z",
      "updated_at": "2026-01-28T12:00:00Z"
    }
  ],
  "links": {
    "first": "http://localhost/octopus/public/api/v1/favourites?page=1",
    "last": "http://localhost/octopus/public/api/v1/favourites?page=1",
    "prev": null,
    "next": null
  },
  "meta": {
    "current_page": 1,
    "from": 1,
    "last_page": 1,
    "per_page": 15,
    "to": 1,
    "total": 1
  }
}</div>
                </div>

                <!-- Add to Favourites -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method post">POST</span>
                        <span class="endpoint-url">/favourites</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Add a product to favourites</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE
Content-Type: application/json</div>

                    <div class="code-label">Request Body:</div>
                    <div class="code-block">{
  "product_id": 5
}</div>

                    <div class="field-rules">
                        <h4>Validation Rules:</h4>
                        <ul>
                            <li><strong>product_id</strong> - required, must exist in products table</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (201 Created):</div>
                    <div class="code-block">{
  "data": {
    "id": 1,
    "user_id": 1,
    "product_id": 5,
    "product": {
      "id": 5,
      "product_id": "1005010479585647",
      "category_id": 13,
      "category": {
        "id": 13,
        "name_ar": "الإلكترونيات الاستهلاكية",
        "name_en": "Consumer Electronics"
      },
      "source": "aliexpress",
      "image_url": "https://example.com/image.jpg",
      "name_ar": "لابتوب...",
      "name_en": "Gaming Laptop...",
      "price": "834.57",
      "discount_price": "632.24",
      "discount": "24.00",
      "currency": "EGP"
    },
    "created_at": "2026-01-28T12:00:00Z",
    "updated_at": "2026-01-28T12:00:00Z"
  }
}</div>
                    <div class="tip">💡 If product is already in favourites, duplicate entries will be created (consider adding unique constraint if needed).</div>
                </div>

                <!-- Remove from Favourites -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <span class="method delete">DELETE</span>
                        <span class="endpoint-url">/favourites/{product_id}</span>
                        <span class="auth-required">Auth Required</span>
                    </div>
                    <div class="endpoint-description">Remove a product from favourites</div>

                    <div class="code-label">Headers:</div>
                    <div class="code-block">Authorization: Bearer YOUR_ACCESS_TOKEN_HERE</div>

                    <div class="code-label">URL Parameters:</div>
                    <div class="field-rules">
                        <ul>
                            <li><strong>product_id</strong> - required, the product ID to remove from favourites</li>
                        </ul>
                    </div>

                    <div class="code-label">Response (200 OK):</div>
                    <div class="code-block">{
  "message": "Product removed from favourites."
}</div>

                    <div class="code-label">Response (404 Not Found):</div>
                    <div class="code-block">{
  "message": "Favourite not found."
}</div>
                    <div class="warning">⚠️ Returns 404 if the product is not in the user's favourites list.</div>
                </div>

                <h3 style="color: #667eea; margin-top: 30px;">Common Use Cases</h3>

                <div class="workflow">
                    <h4>Heart Button Toggle Pattern</h4>
                    <ol>
                        <li>Check if product is in favourites (query GET /favourites and check product_id)</li>
                        <li>If not favourited, call POST /favourites with product_id</li>
                        <li>If already favourited, call DELETE /favourites/{product_id}</li>
                        <li>Update UI to reflect favourite status</li>
                    </ol>
                </div>

                <div class="workflow">
                    <h4>Favourites Page</h4>
                    <ol>
                        <li>Call GET /favourites to fetch user's favourited products</li>
                        <li>Display products in a grid/list with full product details</li>
                        <li>Implement pagination for large favourite lists</li>
                        <li>Add remove button for each product (DELETE /favourites/{product_id})</li>
                    </ol>
                </div>

                <div class="code-label">JavaScript Example - Toggle Favourite:</div>
                <div class="code-block">async function toggleFavourite(productId) {
  const token = localStorage.getItem('access_token');

  // Check if currently favourited
  const isFavourited = checkIfFavourited(productId);

  try {
    if (isFavourited) {
      // Remove from favourites
      const response = await fetch(`http://localhost/api/v1/favourites/${productId}`, {
        method: 'DELETE',
        headers: {
          'Authorization': `Bearer ${token}`
        }
      });

      if (response.ok) {
        console.log('Removed from favourites');
        updateHeartButton(productId, false);
      }
    } else {
      // Add to favourites
      const response = await fetch('http://localhost/api/v1/favourites', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`
        },
        body: JSON.stringify({ product_id: productId })
      });

      if (response.ok) {
        console.log('Added to favourites');
        updateHeartButton(productId, true);
      }
    }
  } catch (error) {
    console.error('Error toggling favourite:', error);
  }
}

// Update heart button UI
function updateHeartButton(productId, isFavourited) {
  const button = document.querySelector(`[data-product-id="${productId}"]`);
  if (button) {
    button.classList.toggle('active', isFavourited);
    button.innerHTML = isFavourited ? '❤️' : '🤍';
  }
}</div>

                <div class="code-label">React Hook Example:</div>
                <div class="code-block">import { useState, useEffect } from 'react';

export function useFavourites() {
  const [favourites, setFavourites] = useState([]);
  const [loading, setLoading] = useState(false);

  const fetchFavourites = async () => {
    setLoading(true);
    const token = localStorage.getItem('access_token');
    const response = await fetch('/api/v1/favourites', {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    });
    const data = await response.json();
    setFavourites(data.data);
    setLoading(false);
  };

  const addFavourite = async (productId) => {
    const token = localStorage.getItem('access_token');
    const response = await fetch('/api/v1/favourites', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Authorization': `Bearer ${token}`
      },
      body: JSON.stringify({ product_id: productId })
    });
    const data = await response.json();
    setFavourites([...favourites, data.data]);
    return data;
  };

  const removeFavourite = async (productId) => {
    const token = localStorage.getItem('access_token');
    await fetch(`/api/v1/favourites/${productId}`, {
      method: 'DELETE',
      headers: {
        'Authorization': `Bearer ${token}`
      }
    });
    setFavourites(favourites.filter(f => f.product_id !== productId));
  };

  const isFavourited = (productId) => {
    return favourites.some(f => f.product_id === productId);
  };

  useEffect(() => {
    fetchFavourites();
  }, []);

  return {
    favourites,
    loading,
    addFavourite,
    removeFavourite,
    isFavourited,
    refetch: fetchFavourites
  };
}</div>

                <div class="tip">💡 Favourites are user-specific - each user has their own favourite products list.</div>
                <div class="tip">🔒 All favourites endpoints require authentication.</div>
                <div class="tip">📊 Favourites list supports pagination for large collections.</div>
            </div>

            <!-- AI Assistant Section -->
            <div id="assistant" class="section">
                <h2>🤖 AI Shopping Assistant</h2>
                <p>Intelligent conversational AI assistant powered by Prism LLM with tool calling capabilities. The assistant can search products, compare options, find deals, and provide personalized recommendations.</p>

                <h3 style="color: #667eea; margin-top: 30px;">Features</h3>
                <ul>
                    <li><strong>Natural Language Chat</strong> - Conversate naturally to find products</li>
                    <li><strong>Tool Calling</strong> - AI can search, compare, and analyze products in real-time</li>
                    <li><strong>Conversation History</strong> - Continuous conversations with ULID-based session tracking</li>
                    <li><strong>Streaming Responses</strong> - Real-time streaming via Server-Sent Events (SSE)</li>
                    <li><strong>Multi-Language</strong> - Supports English and Arabic</li>
                </ul>

                <h3 style="color: #667eea; margin-top: 30px;">Available Tools</h3>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Tool</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>search_products</code></td>
                            <td>Search products by name, category, price range</td>
                        </tr>
                        <tr>
                            <td><code>get_product_details</code></td>
                            <td>Get detailed information about a specific product</td>
                        </tr>
                        <tr>
                            <td><code>compare_products</code></td>
                            <td>Compare multiple products across features and price</td>
                        </tr>
                        <tr>
                            <td><code>find_deals</code></td>
                            <td>Find best deals, discounts, and promotions</td>
                        </tr>
                        <tr>
                            <td><code>get_recommendations</code></td>
                            <td>Get trending, similar, or personalized recommendations</td>
                        </tr>
                        <tr>
                            <td><code>get_categories</code></td>
                            <td>List all available product categories</td>
                        </tr>
                        <tr>
                            <td><code>get_category_products</code></td>
                            <td>Get products in a specific category with sorting</td>
                        </tr>
                    </tbody>
                </table>

                <h3 style="color: #667eea; margin-top: 30px;">Endpoints</h3>

                <!-- Chat Endpoint -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method post">POST</span>
                            <span class="endpoint-url">/assistant/chat</span>
                            <span class="badge badge-required">Auth Required</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Send a message to the AI assistant and receive a response</div>

                    <h4 style="margin-top: 16px;">Request Body</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "message": "What are the best deals under $100?",
  "conversation_id": "01ARZ3NDEKTSV4RRFFQ69G5FAV"  // Optional - continue existing conversation
}</div>

                    <h4 style="margin-top: 16px;">Response</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "success": true,
  "data": {
    "response": "Here are some great deals under $100...",
    "conversation_id": "01ARZ3NDEKTSV4RRFFQ69G5FAV"
  },
  "metadata": {
    "provider": "mistral",
    "tools_used": ["find_deals", "search_products"]
  }
}</div>
                </div>

                <!-- Chat Free Endpoint -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method post">POST</span>
                            <span class="endpoint-url">/assistant/chat/free</span>
                            <span class="badge badge-optional">No Auth</span>
                            <span class="badge badge-info">Rate Limited: 10/min</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Guest access to AI assistant (no authentication required)</div>

                    <h4 style="margin-top: 16px;">Request Body</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "message": "Find me gaming laptops"
}</div>
                </div>

                <!-- Stream Endpoint -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method post">POST</span>
                            <span class="endpoint-url">/assistant/stream</span>
                            <span class="badge badge-required">Auth Required</span>
                            <span class="badge badge-info">SSE Stream</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Stream AI responses in real-time using Server-Sent Events</div>

                    <h4 style="margin-top: 16px;">Stream Events</h4>
                    <div class="code-label">Event Types</div>
                    <div class="code-block">// Content chunk
data: {"type":"content","content":"Here"}

// Tool call
data: {"type":"tool_call","tool":"search_products","arguments":{...}}

// Tool result
data: {"type":"tool_result","tool":"search_products","result":"..."}

// Done
data: {"type":"done","conversation_id":"01ARZ3NDEKTSV4RRFFQ69G5FAV"}

// Error
data: {"type":"error","error":"..."}</div>
                </div>

                <!-- Conversations List -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method get">GET</span>
                            <span class="endpoint-url">/assistant/conversations</span>
                            <span class="badge badge-required">Auth Required</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Get all conversations for the authenticated user</div>

                    <h4 style="margin-top: 16px;">Response</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "success": true,
  "data": {
    "conversations": [
      {
        "id": "01ARZ3NDEKTSV4RRFFQ69G5FAV",
        "title": "Best gaming laptops under $1000",
        "last_message_at": "2026-02-03T10:30:00.000000Z",
        "message_count": 8
      }
    ],
    "total": 1
  }
}</div>
                </div>

                <!-- Get Conversation -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method get">GET</span>
                            <span class="endpoint-url">/assistant/conversations/{ulid}</span>
                            <span class="badge badge-required">Auth Required</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Get all messages in a specific conversation</div>

                    <h4 style="margin-top: 16px;">URL Parameters</h4>
                    <ul>
                        <li><strong>ulid</strong> - The conversation ULID</li>
                    </ul>

                    <h4 style="margin-top: 16px;">Response</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "success": true,
  "data": {
    "conversation_id": "01ARZ3NDEKTSV4RRFFQ69G5FAV",
    "messages": [
      {
        "id": 1,
        "role": "user",
        "content": "Find gaming laptops",
        "created_at": "2026-02-03T10:30:00.000000Z"
      },
      {
        "id": 2,
        "role": "assistant",
        "content": "I found several gaming laptops...",
        "created_at": "2026-02-03T10:30:05.000000Z"
      }
    ],
    "total": 2
  }
}</div>
                </div>

                <!-- Delete Conversation -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method delete">DELETE</span>
                            <span class="endpoint-url">/assistant/conversations/{ulid}</span>
                            <span class="badge badge-required">Auth Required</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Delete a conversation and all its messages</div>

                    <h4 style="margin-top: 16px;">Response</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "success": true,
  "message": "Conversation deleted successfully."
}</div>
                </div>

                <!-- Get History -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method get">GET</span>
                            <span class="endpoint-url">/assistant/history</span>
                            <span class="badge badge-required">Auth Required</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Get message history for a conversation (alias for GET /conversations/{ulid})</div>

                    <h4 style="margin-top: 16px;">Query Parameters</h4>
                    <ul>
                        <li><strong>conversation_id</strong> - The conversation ULID</li>
                    </ul>
                </div>

                <!-- Clear History -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method post">POST</span>
                            <span class="endpoint-url">/assistant/clear-history</span>
                            <span class="badge badge-required">Auth Required</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Delete a conversation by ID</div>

                    <h4 style="margin-top: 16px;">Request Body</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "conversation_id": "01ARZ3NDEKTSV4RRFFQ69G5FAV"
}</div>
                </div>

                <!-- Get Suggestions -->
                <div class="endpoint">
                    <div class="endpoint-header">
                        <div>
                            <span class="method get">GET</span>
                            <span class="endpoint-url">/assistant/suggestions</span>
                            <span class="badge badge-optional">No Auth</span>
                        </div>
                    </div>
                    <div class="endpoint-description">Get suggested follow-up questions to help users explore further</div>

                    <h4 style="margin-top: 16px;">Response</h4>
                    <div class="code-label">JSON</div>
                    <div class="code-block">{
  "success": true,
  "data": {
    "suggestions": [
      "Find products under [price]",
      "What are the best deals today?",
      "Recommend products in [category]",
      "Compare products [id1], [id2], [id3]",
      "Tell me about product [id]",
      "Show me trending products",
      "Find products with discounts above 20%",
      "Show me the highest-rated products"
    ],
    "count": 8
  }
}</div>
                </div>

                <h3 style="color: #667eea; margin-top: 30px;">Example Usage</h3>

                <h4 style="margin-top: 16px;">JavaScript (Fetch API)</h4>
                <div class="code-label">Chat with AI Assistant</div>
                <div class="code-block">async function chatWithAI(message, conversationId = null) {
  const response = await fetch(`${API_BASE_URL}/assistant/chat/free`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({
      message,
      conversation_id: conversationId
    })
  });

  const data = await response.json();
  return data;
}

// Start a new conversation
const result = await chatWithAI("What are the best deals today?");
console.log(result.data.response);
console.log("Conversation ID:", result.data.conversation_id);

// Continue the conversation
const followUp = await chatWithAI(
  "Show me more details about the first product",
  result.data.conversation_id
);</div>

                <h4 style="margin-top: 16px;">JavaScript (Streaming)</h4>
                <div class="code-label">Stream AI Response</div>
                <div class="code-block">async function streamAIChat(message, onChunk, onDone, onError) {
  const response = await fetch(`${API_BASE_URL}/assistant/stream`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'Authorization': `Bearer ${token}`
    },
    body: JSON.stringify({ message })
  });

  const reader = response.body.getReader();
  const decoder = new TextDecoder();
  let buffer = '';

  while (true) {
    const { done, value } = await reader.read();
    if (done) break;

    buffer += decoder.decode(value, { stream: true });
    const lines = buffer.split('\n');
    buffer = lines.pop();

    for (const line of lines) {
      if (line.startsWith('data: ')) {
        const data = JSON.parse(line.slice(6));
        if (data.type === 'content') onChunk(data.content);
        if (data.type === 'done') onDone(data.conversation_id);
        if (data.type === 'error') onError(data.error);
      }
    }
  }
}

// Usage
streamAIChat(
  "Find me deals under $50",
  (chunk) => process.stdout.write(chunk),
  (conversationId) => console.log('\nDone! ID:', conversationId),
  (error) => console.error('Error:', error)
);</div>

                <h4 style="margin-top: 16px;">React Hook</h4>
                <div class="code-label">useAIAssistant Hook</div>
                <div class="code-block">import { useState, useCallback } from 'react';

export function useAIAssistant() {
  const [loading, setLoading] = useState(false);
  const [conversationId, setConversationId] = useState(null);

  const sendMessage = useCallback(async (message) => {
    setLoading(true);
    try {
      const response = await fetch(`${API_BASE_URL}/assistant/chat/free`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ message, conversation_id: conversationId })
      });

      const data = await response.json();
      if (data.success) {
        setConversationId(data.data.conversation_id);
        return data.data.response;
      }
      throw new Error(data.message);
    } finally {
      setLoading(false);
    }
  }, [conversationId]);

  const reset = useCallback(() => {
    setConversationId(null);
  }, []);

  return { sendMessage, loading, conversationId, reset };
}

// Usage in component
function ChatComponent() {
  const { sendMessage, loading, conversationId, reset } = useAIAssistant();
  const [messages, setMessages] = useState([]);

  const handleSend = async () => {
    const response = await sendMessage(inputValue);
    setMessages(prev => [...prev,
      { role: 'user', content: inputValue },
      { role: 'assistant', content: response }
    ]);
  };

  return (
    <div>
      <div className="messages">
        {messages.map((msg, i) => (
          <div key={i} className={msg.role}>{msg.content}</div>
        ))}
      </div>
      <button onClick={handleSend} disabled={loading}>
        {loading ? 'Sending...' : 'Send'}
      </button>
      {conversationId && (
        <button onClick={reset}>New Conversation</button>
      )}
    </div>
  );
}</div>

                <div class="tip">🤖 The AI assistant uses tool calling to interact with the database in real-time, providing up-to-date product information.</div>
                <div class="tip">🔄 Conversation IDs are ULIDs - URL-safe unique identifiers that are chronologically sortable.</div>
                <div class="tip">⚡ The /assistant/chat/free endpoint has rate limiting (10 requests per minute) for guest users.</div>
                <div class="tip">📡 Streaming responses use Server-Sent Events (SSE) for real-time delivery of AI-generated content.</div>
            </div>

            <!-- Errors Section -->
            <div id="errors" class="section">
                <h2>❌ Error Handling</h2>

                <table class="table">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Error Type</th>
                            <th>When It Happens</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><span class="status-code status-200">200</span></td>
                            <td>OK</td>
                            <td>Successful GET, PUT, POST logout</td>
                        </tr>
                        <tr>
                            <td><span class="status-code status-201">201</span></td>
                            <td>Created</td>
                            <td>Successful registration, profile creation</td>
                        </tr>
                        <tr>
                            <td><span class="status-code status-401">401</span></td>
                            <td>Unauthorized</td>
                            <td>Invalid credentials, missing/invalid token</td>
                        </tr>
                        <tr>
                            <td><span class="status-code status-422">422</span></td>
                            <td>Unprocessable Entity</td>
                            <td>Validation errors (email taken, password weak, etc.)</td>
                        </tr>
                    </tbody>
                </table>

                <h3 style="color: #667eea; margin-top: 30px;">Common Errors</h3>

                <div class="endpoint">
                    <div class="code-label">401 - Invalid Credentials:</div>
                    <div class="code-block">{
  "message": "Invalid credentials"
}</div>
                </div>

                <div class="endpoint">
                    <div class="code-label">401 - Unauthenticated:</div>
                    <div class="code-block">{
  "message": "Unauthenticated."
}</div>
                    <div class="tip">💡 Make sure you're sending the Authorization header with a valid token!</div>
                </div>

                <div class="endpoint">
                    <div class="code-label">422 - Validation Error:</div>
                    <div class="code-block">{
  "message": "The given data was invalid.",
  "errors": {
    "email": ["The email has already been taken."],
    "password": ["The password must be at least 8 characters."]
  }
}</div>
                    <div class="tip">💡 Check the "errors" object for field-specific messages!</div>
                </div>
            </div>

            <!-- Examples Section -->
            <div id="examples" class="section">
                <h2>💻 Implementation Examples</h2>

                <h3 style="color: #667eea; margin-top: 20px;">JavaScript (Fetch API)</h3>

                <div class="code-label">1. Register:</div>
                <div class="code-block">const registerResponse = await fetch('http://localhost/api/v1/register', {
  method: 'POST',
  headers: { 'Content-Type': 'application/json' },
  body: JSON.stringify({
    first_name: 'John',
    last_name: 'Doe',
    email: 'john@example.com',
    password: 'password123',
    password_confirmation: 'password123'
  })
});

const registerData = await registerResponse.json();
const token = registerData.access_token;
localStorage.setItem('access_token', token);</div>

                <div class="code-label">2. Create Profile:</div>
                <div class="code-block">const profileResponse = await fetch('http://localhost/api/v1/profile', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
    'Authorization': `Bearer ${token}`
  },
  body: JSON.stringify({
    gender: 'male',
    birth_date: '1990-01-15',
    city: 'New York'
  })
});

const profileData = await profileResponse.json();
console.log('Profile created:', profileData.data);</div>

                <div class="code-label">3. Get User:</div>
                <div class="code-block">const userResponse = await fetch('http://localhost/api/v1/user', {
  headers: { 'Authorization': `Bearer ${token}` }
});

const userData = await userResponse.json();
console.log('User:', userData.data);</div>

                <div class="code-label">4. Logout:</div>
                <div class="code-block">await fetch('http://localhost/api/v1/logout', {
  method: 'POST',
  headers: { 'Authorization': `Bearer ${token}` }
});

localStorage.removeItem('access_token');</div>

                <h3 style="color: #667eea; margin-top: 30px;">Vue.js Helper</h3>
                <div class="code-block">export const useApi = () => {
  const API_BASE = 'http://localhost/api/v1';

  async function apiCall(endpoint, method = 'GET', body = null) {
    const headers = { 'Content-Type': 'application/json' };
    const token = localStorage.getItem('access_token');

    if (token) {
      headers['Authorization'] = `Bearer ${token}`;
    }

    const options = { method, headers };
    if (body) options.body = JSON.stringify(body);

    const response = await fetch(`${API_BASE}${endpoint}`, options);
    const data = await response.json();

    if (!response.ok) {
      throw { status: response.status, data };
    }

    return data;
  }

  return {
    register: (data) => apiCall('/register', 'POST', data),
    login: (data) => apiCall('/login', 'POST', data),
    logout: () => apiCall('/logout', 'POST'),
    getUser: () => apiCall('/user'),
    updateUser: (data) => apiCall('/user', 'PUT', data),
    changePassword: (data) => apiCall('/password', 'PUT', data),
    createProfile: (data) => apiCall('/profile', 'POST', data),
    getProfile: () => apiCall('/profile'),
    updateProfile: (data) => apiCall('/profile', 'PUT', data),
    getSettings: () => apiCall('/settings'),
    updateSettings: (data) => apiCall('/settings', 'PUT', data),
    patchSettings: (data) => apiCall('/settings', 'PATCH', data)
  };
};</div>

                <h3 style="color: #667eea; margin-top: 30px;">React Hook</h3>
                <div class="code-block">import { useState } from 'react';

export function useAuth() {
  const [token, setToken] = useState(localStorage.getItem('access_token'));
  const API_BASE = 'http://localhost/api/v1';

  const register = async (credentials) => {
    const response = await fetch(`${API_BASE}/register`, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(credentials)
    });

    const data = await response.json();

    if (response.ok) {
      const newToken = data.access_token;
      localStorage.setItem('access_token', newToken);
      setToken(newToken);
      return { success: true, data };
    }

    return { success: false, errors: data.errors };
  };

  const logout = async () => {
    await fetch(`${API_BASE}/logout`, {
      method: 'POST',
      headers: {
        'Authorization': `Bearer ${token}`
      }
    });

    localStorage.removeItem('access_token');
    setToken(null);
  };

  return { token, isAuthenticated: !!token, register, logout };
}</div>
            </div>
        </main>
    </div>

    <script>
        // Update base URL display
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('baseUrlValue').textContent = API_BASE_URL;
        });

        // Copy base URL to clipboard
        function copyBaseUrl() {
            const baseUrl = API_BASE_URL;
            navigator.clipboard.writeText(baseUrl).then(function() {
                const button = document.querySelector('.copy-btn');
                const originalText = button.textContent;
                button.textContent = 'Copied!';
                button.classList.add('copied');

                setTimeout(function() {
                    button.textContent = originalText;
                    button.classList.remove('copied');
                }, 2000);
            }).catch(function(err) {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = baseUrl;
                textArea.style.position = 'fixed';
                textArea.style.opacity = '0';
                document.body.appendChild(textArea);
                textArea.select();
                try {
                    document.execCommand('copy');
                    const button = document.querySelector('.copy-btn');
                    const originalText = button.textContent;
                    button.textContent = 'Copied!';
                    button.classList.add('copied');

                    setTimeout(function() {
                        button.textContent = originalText;
                        button.classList.remove('copied');
                    }, 2000);
                } catch (err) {
                    console.error('Failed to copy: ', err);
                }
                document.body.removeChild(textArea);
            });
        }

        function showSection(sectionId) {
            // Hide all sections
            document.querySelectorAll('.section').forEach(section => {
                section.classList.remove('active');
            });

            // Remove active class from all buttons
            document.querySelectorAll('.nav-button').forEach(btn => {
                btn.classList.remove('active');
            });

            // Show selected section
            document.getElementById(sectionId).classList.add('active');

            // Add active class to clicked button
            event.target.classList.add('active');
        }
    </script>
</body>
</html>
