@props(['products', 'title' => null, 'badge' => null, 'locale' => 'en'])

@php
    $isArabic = $locale === 'ar';
@endphp

<div class="ai-product-grid-wrapper">
    @if($title)
        <div class="ai-grid-header flex items-center justify-between mb-3">
            <h3 class="text-sm font-semibold text-gray-900 dark:text-white" dir="{{ $isArabic ? 'rtl' : 'ltr' }}">
                {{ $title }}
                <span class="text-gray-500 dark:text-gray-400 font-normal">({{ $products->count() }})</span>
            </h3>
            @if($badge)
                <span class="px-2 py-1 text-xs font-medium rounded-full bg-gradient-to-r from-purple-500 to-pink-500 text-white">
                    {{ $badge }}
                </span>
            @endif
        </div>
    @endif

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3">
        @forelse($products as $product)
            <x-ai.product-card :product="$product" :badge="$badge" :locale="$locale" />
        @empty
            <div class="col-span-full text-center py-6 text-gray-500 dark:text-gray-400 text-sm">
                {{ $isArabic ? 'لا توجد منتجات' : 'No products found' }}
            </div>
        @endforelse
    </div>
</div>
