@props(['products', 'locale' => 'en'])

@php
    $isArabic = $locale === 'ar';
    $currencySymbol = $isArabic ? 'جنيه' : 'EGP';
@endphp

<div class="ai-comparison-table overflow-x-auto" dir="{{ $isArabic ? 'rtl' : 'ltr' }}">
    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
        <thead class="bg-gray-50 dark:bg-gray-800">
            <tr>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    {{ $isArabic ? 'المنتج' : 'Product' }}
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    {{ $isArabic ? 'السعر' : 'Price' }}
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    {{ $isArabic ? 'الخصم' : 'Discount' }}
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    {{ $isArabic ? 'التقييم' : 'Rating' }}
                </th>
                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    {{ $isArabic ? 'المبيعات' : 'Sales (180d)' }}
                </th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-900 divide-y divide-gray-200 dark:divide-gray-700">
            @php
                $bestPrice = $products->sortBy(fn($p) => $p->discount_price ?? $p->price)->first();
                $topRated = $products->sortByDesc('positive_feedback')->first();
                $bestDeal = $products->sortByDesc('discount')->first();
            @endphp

            @foreach($products as $product)
                @php
                    $price = $product->discount_price ?? $product->price;
                    $isBestPrice = $product->id === $bestPrice->id;
                    $isTopRated = $product->id === $topRated->id;
                    $isBestDeal = $product->discount > 0 && $product->id === $bestDeal->id;
                    $nameField = $isArabic && $product->name_ar ? $product->name_ar : $product->name_en;
                    $categoryName = $product->category ? ($isArabic && $product->category->name_ar ? $product->category->name_ar : $product->category->name_en) : null;
                @endphp

                <tr class="hover:bg-gray-50 dark:hover:bg-gray-800">
                    <td class="px-4 py-3">
                        <div class="flex items-center gap-2">
                            @if($product->image_url)
                                <img src="{{ $product->image_url }}" alt="{{ $nameField }}" class="w-8 h-8 rounded object-cover">
                            @endif
                            <div>
                                <p class="text-sm font-medium text-gray-900 dark:text-white">
                                    {{ \Illuminate\Support\Str::limit($nameField, 30) }}
                                </p>
                                @if($categoryName)
                                    <p class="text-xs text-gray-500 dark:text-gray-400">
                                        {{ $categoryName }}
                                    </p>
                                @endif
                            </div>
                        </div>
                    </td>

                    <td class="px-4 py-3">
                        <div class="flex items-center gap-2">
                            <span class="text-sm font-medium text-gray-900 dark:text-white">
                                {{ number_format($price, 2) }} {{ $currencySymbol }}
                            </span>
                            @if($isBestPrice)
                                <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400">
                                    {{ $isArabic ? 'أفضل سعر' : 'Best Price' }}
                                </span>
                            @endif
                        </div>
                    </td>

                    <td class="px-4 py-3">
                        @if($product->discount > 0)
                            <div class="flex items-center gap-2">
                                <span class="text-sm font-medium text-gray-900 dark:text-white">
                                    {{ number_format($product->discount, 0) }}%
                                </span>
                                @if($isBestDeal)
                                    <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-red-100 dark:bg-red-900/30 text-red-600 dark:text-red-400">
                                        {{ $isArabic ? 'أفضل صفقة' : 'Best Deal' }}
                                    </span>
                                @endif
                            </div>
                        @else
                            <span class="text-sm text-gray-400">-</span>
                        @endif
                    </td>

                    <td class="px-4 py-3">
                        <div class="flex items-center gap-2">
                            <div class="flex items-center gap-1">
                                <svg class="w-3.5 h-3.5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                </svg>
                                <span class="text-sm font-medium text-gray-900 dark:text-white">
                                    {{ number_format($product->positive_feedback, 0) }}%
                                </span>
                            </div>
                            @if($isTopRated)
                                <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-yellow-100 dark:bg-yellow-900/30 text-yellow-600 dark:text-yellow-400">
                                    {{ $isArabic ? 'الأعلى تقييماً' : 'Top Rated' }}
                                </span>
                            @endif
                        </div>
                    </td>

                    <td class="px-4 py-3 text-sm text-gray-600 dark:text-gray-400">
                        {{ $product->sales_180day ?? 0 }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{-- Key insights section --}}
    <div class="mt-4 p-3 bg-gray-50 dark:bg-gray-800 rounded-lg">
        <h4 class="text-xs font-semibold text-gray-700 dark:text-gray-300 mb-2">{{ $isArabic ? 'أبرز النقاط' : 'Key Insights' }}</h4>
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-2 text-xs">
            <div class="flex items-center gap-2">
                <span class="px-1.5 py-0.5 rounded bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 font-medium">{{ $isArabic ? 'أفضل سعر' : 'Best Price' }}</span>
                <span class="text-gray-600 dark:text-gray-400">{{ $isArabic && $bestPrice->name_ar ? $bestPrice->name_ar : $bestPrice->name_en }} ({{ number_format($bestPrice->discount_price ?? $bestPrice->price, 2) }} {{ $currencySymbol }})</span>
            </div>
            <div class="flex items-center gap-2">
                <span class="px-1.5 py-0.5 rounded bg-yellow-100 dark:bg-yellow-900/30 text-yellow-600 dark:text-yellow-400 font-medium">{{ $isArabic ? 'الأعلى تقييماً' : 'Top Rated' }}</span>
                <span class="text-gray-600 dark:text-gray-400">{{ $isArabic && $topRated->name_ar ? $topRated->name_ar : $topRated->name_en }} ({{ number_format($topRated->positive_feedback, 0) }}%)</span>
            </div>
            @if($bestDeal->discount > 0)
            <div class="flex items-center gap-2">
                <span class="px-1.5 py-0.5 rounded bg-red-100 dark:bg-red-900/30 text-red-600 dark:text-red-400 font-medium">{{ $isArabic ? 'أفضل صفقة' : 'Best Deal' }}</span>
                <span class="text-gray-600 dark:text-gray-400">{{ $isArabic && $bestDeal->name_ar ? $bestDeal->name_ar : $bestDeal->name_en }} ({{ number_format($bestDeal->discount, 0) }}% {{ $isArabic ? 'خصم' : 'off' }})</span>
            </div>
            @endif
        </div>
    </div>
</div>
