<x-admin.layout title="Edit Product">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Edit Product</h2>
    </div>

    <x-admin.card>
        <form action="{{ route('admin.products.update', $product) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Basic Information -->
                <div class="md:col-span-2">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Basic Information</h3>
                </div>

                <x-admin.form.select name="category_id" label="Category" :options="$categories->pluck('name_en', 'id')" :value="$product->category_id" required />

                <x-admin.form.select
                    name="source"
                    label="Source"
                    :options="['aliexpress' => 'AliExpress', 'amazon' => 'Amazon', 'noon' => 'Noon']"
                    :value="$product->source"
                    required
                />

                <x-admin.form.input name="product_id" label="Product ID" :value="$product->product_id" placeholder="External product ID" />

                <div></div>

                <x-admin.form.input name="name_en" label="Name (English)" :value="$product->name_en" required />

                <x-admin.form.input name="name_ar" label="Name (Arabic)" :value="$product->name_ar" required />

                <x-admin.form.textarea name="description_en" label="Description (English)" :value="$product->description_en" rows="4" />

                <x-admin.form.textarea name="description_ar" label="Description (Arabic)" :value="$product->description_ar" rows="4" />

                <!-- Images & Media -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Images & Media</h3>
                </div>

                <x-admin.form.input name="image_url" label="Image URL" type="url" :value="$product->image_url" />

                <x-admin.form.input name="video_url" label="Video URL" type="url" :value="$product->video_url" />

                <!-- Pricing -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Pricing</h3>
                </div>

                <x-admin.form.input name="price" label="Price" type="number" step="0.01" :value="$product->price" required />

                <x-admin.form.select
                    name="currency"
                    label="Currency"
                    :options="['EGP' => 'EGP', 'USD' => 'USD', 'EUR' => 'EUR']"
                    :value="$product->currency"
                    required
                />

                <x-admin.form.input name="discount_price" label="Discount Price" type="number" step="0.01" :value="$product->discount_price" />

                <x-admin.form.input name="discount" label="Discount (%)" type="number" step="0.01" :value="$product->discount" />

                <!-- Promotion -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Promotion & Commission</h3>
                </div>

                <x-admin.form.input name="promotion_url" label="Promotion URL" type="url" :value="$product->promotion_url" />

                <x-admin.form.input name="direct_commission_rate" label="Direct Commission Rate (%)" type="number" step="0.01" :value="$product->direct_commission_rate" />

                <x-admin.form.input name="estimated_direct_commission" label="Estimated Direct Commission" type="number" step="0.01" :value="$product->estimated_direct_commission" />

                <x-admin.form.input name="indirect_commission_rate" label="Indirect Commission Rate (%)" type="number" step="0.01" :value="$product->indirect_commission_rate" />
            </div>

            <div class="mt-6 flex items-center justify-end gap-3">
                <a href="{{ route('admin.products.index') }}">
                    <x-admin.form.button type="button" variant="outline">Cancel</x-admin.form.button>
                </a>
                <x-admin.form.button type="submit">Update Product</x-admin.form.button>
            </div>
        </form>
    </x-admin.card>
</x-admin.layout>
