<x-admin.layout title="Edit AI Provider">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Edit AI Provider</h2>
    </div>

    <div class="max-w-3xl">
        <x-admin.card>
            <form action="{{ route('admin.ai-providers.update', $ai_provider) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <x-admin.form.input name="name" label="Provider Name" required :value="$ai_provider->name" />

                    <x-admin.form.input name="code" label="Provider Code" required :value="$ai_provider->code" help="Unique identifier for the provider" />
                </div>

                <x-admin.form.input
                    name="api_key"
                    label="API Key"
                    type="password"
                    :placeholder="$ai_provider->masked_api_key"
                    help="Leave empty to keep existing key"
                    onfocus="this.setAttribute('data-changed', '1'); this.value = '';"
                />
                <input type="hidden" name="api_key_changed" id="api_key_changed" value="0">

                <x-admin.form.input name="api_url" label="API URL" type="url" :value="$ai_provider->api_url" />

                <x-admin.form.input name="model" label="Model" :value="$ai_provider->model" />

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Capabilities
                    </label>
                    <div class="grid grid-cols-2 md:grid-cols-3 gap-2">
                        @foreach(['chat', 'vision', 'reasoning', 'tools', 'streaming'] as $capability)
                            <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 @if(in_array($capability, $ai_provider->capabilities ?? [])) bg-blue-50 dark:bg-blue-900 border-blue-300 dark:border-blue-600 @endif">
                                <input type="checkbox" name="capabilities[]" value="{{ $capability }}" @if(in_array($capability, $ai_provider->capabilities ?? [])) checked @endif class="mr-2 rounded text-blue-600">
                                <span class="text-sm text-gray-700 dark:text-gray-300">{{ ucfirst($capability) }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="flex items-center">
                            <input type="checkbox" name="is_enabled" value="1" @if($ai_provider->is_enabled) checked @endif class="mr-2 rounded text-blue-600">
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Enabled</span>
                        </label>
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Allow this provider to be used</p>
                    </div>

                    <div>
                        <label class="flex items-center">
                            <input type="checkbox" name="is_default" value="1" @if($ai_provider->is_default) checked @endif class="mr-2 rounded text-blue-600">
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Default</span>
                        </label>
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Use as the default AI provider</p>
                    </div>
                </div>

                <div class="border-t border-gray-200 dark:border-gray-700 pt-6 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Advanced Settings</h3>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <x-admin.form.input
                            name="max_tokens"
                            label="Max Tokens"
                            type="number"
                            min="1"
                            max="32000"
                            :value="$ai_provider->max_tokens"
                            placeholder="4096"
                        />

                        <x-admin.form.input
                            name="temperature"
                            label="Temperature"
                            type="number"
                            step="0.01"
                            min="0"
                            max="2"
                            :value="number_format($ai_provider->temperature, 2)"
                            placeholder="0.7"
                        />

                        <x-admin.form.input
                            name="max_steps"
                            label="Max Steps"
                            type="number"
                            min="1"
                            max="20"
                            :value="$ai_provider->max_steps"
                            placeholder="5"
                            help="Max tool calling steps"
                        />
                    </div>
                </div>

                <div class="mt-6 flex items-center justify-end gap-3">
                    <a href="{{ route('admin.ai-providers.index') }}">
                        <x-admin.form.button type="button" variant="outline">Cancel</x-admin.form.button>
                    </a>
                    <x-admin.form.button type="submit">Update Provider</x-admin.form.button>
                </div>
            </form>
        </x-admin.card>
    </div>
</x-admin.layout>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const apiKeyInput = document.querySelector('input[name="api_key"]');
        const apiKeyChangedInput = document.getElementById('api_key_changed');

        if (apiKeyInput && apiKeyChangedInput) {
            apiKeyInput.addEventListener('input', function() {
                apiKeyChangedInput.value = '1';
            });
        }
    });
</script>
