<x-admin.layout title="Edit Advertisement">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Edit Advertisement</h2>
    </div>

    <x-admin.card>
        <form action="{{ route('admin.advertisements.update', $advertisement) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Basic Information -->
                <div class="md:col-span-2">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Basic Information</h3>
                </div>

                <x-admin.form.input name="title_en" label="Title (English)" :value="$advertisement->title_en" required />

                <x-admin.form.input name="title_ar" label="Title (Arabic)" :value="$advertisement->title_ar" required />

                <x-admin.form.input name="url" label="Link URL" type="url" :value="$advertisement->url" required />

                <div></div>

                <!-- Image -->
                <div class="md:col-span-2 mt-4">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Image</h3>
                </div>

                <div class="md:col-span-2">
                    @if($advertisement->image)
                        <div class="mb-4">
                            <p class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Current Image:</p>
                            <img src="{{ Storage::url($advertisement->image) }}" alt="{{ $advertisement->title_en }}" class="h-48 rounded object-cover">
                        </div>
                    @endif

                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        New Image <span class="text-gray-500">(leave empty to keep current)</span>
                    </label>
                    <input
                        type="file"
                        name="image"
                        id="imageInput"
                        accept="image/jpeg,image/png,image/jpg,image/gif,image/webp"
                        class="block w-full text-sm text-gray-500 dark:text-gray-400
                            file:mr-4 file:py-2 file:px-4
                            file:rounded-md file:border-0
                            file:text-sm file:font-semibold
                            file:bg-blue-50 file:text-blue-700
                            hover:file:bg-blue-100
                            dark:file:bg-blue-900 dark:file:text-blue-200
                            cursor-pointer"
                    >
                    <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                        Recommended size: 1200x400 pixels. Maximum file size: 5MB.
                        Supported formats: JPG, PNG, GIF, WebP.
                    </p>
                    <div id="imagePreview" class="mt-4 hidden">
                        <p class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">New Image Preview:</p>
                        <img id="previewImg" src="" alt="Preview" class="h-48 rounded object-cover">
                    </div>
                </div>

                <!-- Status & Schedule -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Status & Schedule</h3>
                </div>

                <x-admin.form.select
                    name="status"
                    label="Status"
                    :options="['active' => 'Active', 'inactive' => 'Inactive']"
                    :selected="$advertisement->status"
                    required
                />

                <x-admin.form.input name="sort_order" label="Sort Order" type="number" :value="$advertisement->sort_order" required />

                <x-admin.form.input name="start_date" label="Start Date" type="date" :value="$advertisement->start_date?->format('Y-m-d')" />

                <x-admin.form.input name="end_date" label="End Date" type="date" :value="$advertisement->end_date?->format('Y-m-d')" />

                <!-- Targeting -->
                <div class="md:col-span-2 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Targeting</h3>
                </div>

                <x-admin.form.select
                    name="targeted_audience"
                    label="Target Audience"
                    :options="['all' => 'All Users', 'male' => 'Male', 'female' => 'Female']"
                    :selected="$advertisement->targeted_audience"
                    required
                />

                <x-admin.form.select
                    name="targeted_language"
                    label="Target Language"
                    :options="['both' => 'Arabic & English', 'ar' => 'Arabic Only', 'en' => 'English Only']"
                    :selected="$advertisement->targeted_language"
                    required
                />
            </div>

            <div class="mt-6 flex items-center justify-end gap-3">
                <a href="{{ route('admin.advertisements.index') }}">
                    <x-admin.form.button type="button" variant="outline">Cancel</x-admin.form.button>
                </a>
                <x-admin.form.button type="submit">Update Advertisement</x-admin.form.button>
            </div>
        </form>
    </x-admin.card>

    <script>
        document.getElementById('imageInput')?.addEventListener('change', function(e) {
            const file = e.target.files[0];
            const preview = document.getElementById('imagePreview');
            const img = document.getElementById('previewImg');

            if (file) {
                const reader = new FileReader();
                reader.onload = function(evt) {
                    img.src = evt.target.result;
                    preview.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else {
                preview.classList.add('hidden');
            }
        });
    </script>
</x-admin.layout>
