<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * SVG icons for categories.
     */
    private function getIcon(string $type): string
    {
        return match ($type) {
            // Electronics icons
            'computer', 'laptop' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect><line x1="8" y1="21" x2="16" y2="21"></line><line x1="12" y1="17" x2="12" y2="21"></line></svg>',
            'phone', 'mobile' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><rect x="5" y="2" width="14" height="20" rx="2" ry="2"></rect><line x1="12" y1="18" x2="12.01" y2="18"></line></svg>',
            'chip' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><rect x="4" y="4" width="16" height="16" rx="2" ry="2"></rect><rect x="9" y="9" width="6" height="6"></rect><line x1="9" y1="1" x2="9" y2="4"></line><line x1="15" y1="1" x2="15" y2="4"></line><line x1="9" y1="20" x2="9" y2="23"></line><line x1="15" y1="20" x2="15" y2="23"></line><line x1="20" y1="9" x2="23" y2="9"></line><line x1="20" y1="14" x2="23" y2="14"></line><line x1="1" y1="9" x2="4" y2="9"></line><line x1="1" y1="14" x2="4" y2="14"></line></svg>',

            // Home icons
            'house', 'home' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline></svg>',
            'chair', 'furniture' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M19 9V6a2 2 0 0 0-2-2H7a2 2 0 0 0-2 2v3"></path><path d="M3 16a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-5a2 2 0 0 0-4 0v2H7v-2a2 2 0 0 0-4 0v5z"></path><path d="M5 18v2"></path><path d="M19 18v2"></path></svg>',
            'lightbulb' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M9 18h6"></path><path d="M10 22h4"></path><path d="M12 2v1"></path><path d="M12 18v-2"></path><path d="M5.6 5.6l.7 .7"></path><path d="M18.4 5.6l-.7 .7"></path><path d="M15 9a3 3 0 1 1-6 0"></path><path d="M6 15h12"></path></svg>',
            'shield', 'security' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg>',
            'wrench', 'tools' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M14.7 6.3a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0l3.77-3.77a6 6 0 0 1-7.94 7.94l-6.91 6.91a2.12 2.12 0 0 1-3-3l6.91-6.91a6 6 0 0 1 7.94-7.94l-3.76 3.76z"></path></svg>',

            // Fashion icons
            'shirt', 'clothing' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M20.38 3.4a2 2 0 0 0-2-2h-12.76a2 2 0 0 0-2 2L2 8v10a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V8z"></path><path d="M12 12v8"></path><path d="M12 12L8 8"></path><path d="M12 12l4-4"></path></svg>',
            'shoe', 'shoes' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M4 16v-2.38C4 11.5 7.58 9.56 7.58 9.56l1.92-3.82a2 2 0 0 1 1.79-1.11h3.44a2 2 0 0 1 1.79 1.11l1.92 3.82S22 11.5 22 13.62V16a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2z"></path><path d="M11 12h2"></path></svg>',
            'gem', 'jewelry' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M6 3h12l4 6-10 13L2 9z"></path></svg>',
            'watch' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><circle cx="12" cy="12" r="9"></circle><polyline points="12 7 12 12 15 15"></polyline></svg>',
            'suitcase', 'bag', 'luggage' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M6 5v14a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V5"></path><path d="M6 5a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2"></path><path d="M10 10v4"></path><path d="M14 10v4"></path></svg>',

            // Beauty & Health icons
            'heart', 'health', 'beauty' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M20.42 4.58a5.4 5.4 0 0 0-7.65 0l-.77.78-.77-.78a5.4 5.4 0 0 0-7.65 0C1.46 6.7 1.33 10.28 4 13l8 8 8-8c2.67-2.72 2.54-6.3.42-8.42z"></path></svg>',
            'baby', 'mother' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><circle cx="12" cy="5" r="3"></circle><path d="M9 22v-4h6v4"></path><path d="M5 12a7 7 0 0 1 14 0v4h-4v-2H9v2H5v-4z"></path></svg>',

            // Sports & Entertainment icons
            'gamepad', 'game', 'entertainment', 'toy' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="6" y1="12" x2="10" y2="12"></line><line x1="8" y1="10" x2="8" y2="14"></line><line x1="15" y1="13" x2="15.01" y2="13"></line><line x1="18" y1="11" x2="18.01" y2="11"></line><rect x="2" y="6" width="20" height="12" rx="2"></rect></svg>',
            'trophy', 'sports' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M6 9H4.5a2.5 2.5 0 0 1 0-5H6"></path><path d="M18 9h1.5a2.5 2.5 0 0 0 0-5H18"></path><path d="M4 22h16"></path><path d="M10 14.66V17c0 .55-.47.98-.97 1.21C7.85 18.75 7 20.24 7 22"></path><path d="M14 14.66V17c0 .55.47.98.97 1.21C16.15 18.75 17 20.24 17 22"></path><path d="M18 2h-6v6a6 6 0 0 0 12 0V8a2 2 0 0 0-2-2h-4z"></path></svg>',

            // Automotive icons
            'car', 'automotive' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"></path><circle cx="7" cy="17" r="2"></circle><circle cx="17" cy="17" r="2"></circle></svg>',
            'motorcycle' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><circle cx="5" cy="17" r="3"></circle><circle cx="19" cy="17" r="3"></circle><path d="M12 17h-2a2 2 0 0 1-2-2V9.5a2.5 2.5 0 0 1 2.5-2.5h2.7a2 2 0 0 1 1.6.8l1.7 2.2"></path></svg>',

            // Food & General icons
            'utensils', 'food', 'beverage' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M3 2v7c0 1.1.9 2 2 2h4a2 2 0 0 0 2-2V2"></path><path d="M7 2v20"></path><path d="M21 15V2v0a5 5 0 0 0-5 5v6c0 1.1.9 2 2 2h3Zm0 0v7"></path></svg>',
            'book', 'office', 'school' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path><path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path></svg>',
            'industry' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M2 20a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V8l-7-5-7 5v12z"></path><path d="M12 13v9"></path><path d="M12 13l-4-4"></path><path d="M12 13l4-4"></path></svg>',
            'bell', 'notification' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path><path d="M13.73 21a2 2 0 0 1-3.46 0"></path></svg>',
            'help', 'question', 'misc', 'general' => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><circle cx="12" cy="12" r="10"></circle><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>',

            default => '<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><circle cx="12" cy="12" r="10"></circle><path d="M12 6v6l4 2"></path></svg>',
        };
    }

    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $parentCategories = [
            ['name_en' => 'Electronics', 'name_ar' => 'الإلكترونيات', 'icon_type' => 'computer'],
            ['name_en' => 'Home', 'name_ar' => 'المنزل', 'icon_type' => 'house'],
            ['name_en' => 'Fashion & Apparel', 'name_ar' => 'الموضة والملابس', 'icon_type' => 'shirt'],
            ['name_en' => 'Beauty & Health', 'name_ar' => 'الجمال والصحة', 'icon_type' => 'heart'],
            ['name_en' => 'Sports & Entertainment', 'name_ar' => 'الرياضة والترفيه', 'icon_type' => 'gamepad'],
            ['name_en' => 'Automotive', 'name_ar' => 'السيارات', 'icon_type' => 'car'],
            ['name_en' => 'General & Miscellaneous', 'name_ar' => 'عام ومتنوع', 'icon_type' => 'question'],
        ];

        $subCategories = [
            // Electronics & Technology
            'Electronics' => [
                ['name_en' => 'Consumer Electronics', 'name_ar' => 'الإلكترونيات الاستهلاكية', 'icon_type' => 'computer'],
                ['name_en' => 'Phones & Telecommunications', 'name_ar' => 'الهواتف والاتصالات', 'icon_type' => 'phone'],
                ['name_en' => 'Computer & Office', 'name_ar' => 'الكمبيوتر ومستلزمات المكتب', 'icon_type' => 'laptop'],
                ['name_en' => 'Electronic Components & Supplies', 'name_ar' => 'المكونات واللوازم الإلكترونية', 'icon_type' => 'chip'],
                ['name_en' => 'Phones & Telecommunications Accessories', 'name_ar' => 'إكسسوارات الهواتف والاتصالات', 'icon_type' => 'phone'],
            ],
            // Home & Living
            'Home' => [
                ['name_en' => 'Home Appliances', 'name_ar' => 'الأجهزة المنزلية', 'icon_type' => 'house'],
                ['name_en' => 'Home Improvement', 'name_ar' => 'تحسين المنزل', 'icon_type' => 'house'],
                ['name_en' => 'Home & Garden', 'name_ar' => 'المنزل والحديقة', 'icon_type' => 'house'],
                ['name_en' => 'Furniture', 'name_ar' => 'الأثاث', 'icon_type' => 'furniture'],
                ['name_en' => 'Lights & Lighting', 'name_ar' => 'الإضاءة والإنارة', 'icon_type' => 'lightbulb'],
                ['name_en' => 'Security & Protection', 'name_ar' => 'الأمن والحماية', 'icon_type' => 'shield'],
                ['name_en' => 'Tools', 'name_ar' => 'الأدوات', 'icon_type' => 'tools'],
            ],
            // Fashion & Apparel
            'Fashion & Apparel' => [
                ['name_en' => 'Clothing & Apparel', 'name_ar' => 'الملابس', 'icon_type' => 'clothing'],
                ['name_en' => 'Men\'s Clothing', 'name_ar' => 'ملابس رجالية', 'icon_type' => 'shirt'],
                ['name_en' => 'Shoes', 'name_ar' => 'الأحذية', 'icon_type' => 'shoes'],
                ['name_en' => 'Sports Shoes, Clothing & Accessories', 'name_ar' => 'الأحذية الرياضية والملابس والإكسسوارات', 'icon_type' => 'shoe'],
                ['name_en' => 'Underwear', 'name_ar' => 'الملابس الداخلية', 'icon_type' => 'shirt'],
                ['name_en' => 'Apparel Accessories', 'name_ar' => 'إكسسوارات الملابس', 'icon_type' => 'shirt'],
                ['name_en' => 'Jewelry & Accessories', 'name_ar' => 'المجوهرات والإكسسوارات', 'icon_type' => 'jewelry'],
                ['name_en' => 'Watches', 'name_ar' => 'الساعات', 'icon_type' => 'watch'],
                ['name_en' => 'Luggage & Bags', 'name_ar' => 'الحقائب وأمتعة السفر', 'icon_type' => 'luggage'],
            ],
            // Beauty & Health
            'Beauty & Health' => [
                ['name_en' => 'Health & Personal Care', 'name_ar' => 'الصحة والعناية الشخصية', 'icon_type' => 'health'],
                ['name_en' => 'Mother & Kids', 'name_ar' => 'الأم والطفل', 'icon_type' => 'mother'],
            ],
            // Sports & Entertainment
            'Sports & Entertainment' => [
                ['name_en' => 'Entertainment', 'name_ar' => 'الترفيه', 'icon_type' => 'entertainment'],
                ['name_en' => 'Toys & Hobbies', 'name_ar' => 'الألعاب والهوايات', 'icon_type' => 'toy'],
            ],
            // Automotive
            'Automotive' => [
                ['name_en' => 'Car Parts & Accessories', 'name_ar' => 'قطع غيار وإكسسوارات السيارات', 'icon_type' => 'automotive'],
                ['name_en' => 'Motorcycle Equipments & Parts', 'name_ar' => 'معدات وقطع غيار الدراجات النارية', 'icon_type' => 'motorcycle'],
            ],
            // General & Miscellaneous
            'General & Miscellaneous' => [
                ['name_en' => 'Food & Beverages', 'name_ar' => 'الطعام والمشروبات', 'icon_type' => 'food'],
                ['name_en' => 'Office & School Supplies', 'name_ar' => 'لوازم المكتب والمدرسة', 'icon_type' => 'office'],
                ['name_en' => 'Virtual Products', 'name_ar' => 'المنتجات الرقمية', 'icon_type' => 'computer'],
                ['name_en' => 'Industrial & Business', 'name_ar' => 'الصناعة والأعمال', 'icon_type' => 'industry'],
                ['name_en' => 'Weddings & Events', 'name_ar' => 'حفلات الزفاف والمناسبات', 'icon_type' => 'bell'],
                ['name_en' => 'Books & Cultural Merchandise', 'name_ar' => 'الكتب والمنتجات الثقافية', 'icon_type' => 'book'],
                ['name_en' => 'Novelty & Special Use', 'name_ar' => 'منتجات مبتكرة واستخدامات خاصة', 'icon_type' => 'misc'],
                ['name_en' => 'Special Category', 'name_ar' => 'فئة خاصة', 'icon_type' => 'general'],
            ],
        ];

        foreach ($parentCategories as $parentCategory) {
            $parent = \App\Models\Category::create([
                'parent_id' => null,
                'name_en' => $parentCategory['name_en'],
                'name_ar' => $parentCategory['name_ar'],
                'slug' => Str::slug($parentCategory['name_en']),
                'icon' => $this->getIcon($parentCategory['icon_type']),
                'status' => 'active',
            ]);

            if (isset($subCategories[$parentCategory['name_en']])) {
                foreach ($subCategories[$parentCategory['name_en']] as $subCategory) {
                    \App\Models\Category::create([
                        'parent_id' => $parent->id,
                        'name_en' => $subCategory['name_en'],
                        'name_ar' => $subCategory['name_ar'],
                        'slug' => Str::slug($subCategory['name_en']),
                        'icon' => $this->getIcon($subCategory['icon_type']),
                        'status' => 'active',
                    ]);
                }
            }
        }
    }
}
