<?php

namespace Database\Seeders;

use App\Models\AiProvider;
use Illuminate\Database\Seeder;

class AiProviderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $providers = [
            [
                'name' => 'DeepSeek',
                'code' => 'deepseek',
                'api_url' => 'https://api.deepseek.com/v1',
                'model' => 'deepseek-chat',
                'is_enabled' => true,
                'is_default' => false,
                'capabilities' => ['chat', 'reasoning', 'tools', 'streaming'],
                'max_tokens' => 4096,
                'temperature' => 0.7,
                'max_steps' => 5,
            ],
            [
                'name' => 'Mistral AI',
                'code' => 'mistral',
                'api_url' => 'https://api.mistral.ai/v1',
                'model' => 'mistral-large-latest',
                'is_enabled' => true,
                'is_default' => true,
                'capabilities' => ['chat', 'tools', 'streaming'],
                'max_tokens' => 4096,
                'temperature' => 0.7,
                'max_steps' => 5,
            ],
            [
                'name' => 'Google Gemini',
                'code' => 'gemini',
                'api_url' => 'https://generativelanguage.googleapis.com/v1beta/models',
                'model' => 'gemini-2.0-flash',
                'is_enabled' => true,
                'is_default' => false,
                'capabilities' => ['chat', 'vision', 'tools', 'streaming'],
                'max_tokens' => 8192,
                'temperature' => 0.7,
                'max_steps' => 5,
            ],
            [
                'name' => 'OpenAI',
                'code' => 'openai',
                'api_url' => 'https://api.openai.com/v1',
                'model' => 'gpt-4o',
                'is_enabled' => false,
                'is_default' => false,
                'capabilities' => ['chat', 'vision', 'tools', 'streaming'],
                'max_tokens' => 4096,
                'temperature' => 0.7,
                'max_steps' => 5,
            ],
            [
                'name' => 'xAI Grok',
                'code' => 'xai',
                'api_url' => 'https://api.x.ai/v1',
                'model' => 'grok-4-fast',
                'is_enabled' => false,
                'is_default' => false,
                'capabilities' => ['chat', 'vision', 'tools', 'streaming'],
                'max_tokens' => 4096,
                'temperature' => 0.7,
                'max_steps' => 5,
            ],
            [
                'name' => 'Anthropic',
                'code' => 'anthropic',
                'api_url' => 'https://api.anthropic.com/v1',
                'model' => 'claude-3-5-sonnet',
                'is_enabled' => false,
                'is_default' => false,
                'capabilities' => ['chat', 'vision', 'tools', 'streaming'],
                'max_tokens' => 4096,
                'temperature' => 0.7,
                'max_steps' => 5,
            ],
        ];

        foreach ($providers as $provider) {
            AiProvider::firstOrCreate(
                ['code' => $provider['code']],
                $provider
            );
        }
    }
}
