<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Categories table - status filter
        Schema::table('categories', function (Blueprint $table) {
            $table->index('status', 'categories_status_index');
        });

        // Products table - for category filtering and sorting by created_at
        Schema::table('products', function (Blueprint $table) {
            $table->index(['category_id', 'created_at'], 'products_category_created_at_index');
        });

        // Advertisements table - for filtering active ads
        Schema::table('advertisements', function (Blueprint $table) {
            $table->index(['status', 'start_date', 'end_date'], 'advertisements_status_dates_index');
            $table->index('targeted_audience', 'advertisements_targeted_audience_index');
            $table->index('targeted_language', 'advertisements_targeted_language_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropIndex('categories_status_index');
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropIndex('products_category_created_at_index');
        });

        Schema::table('advertisements', function (Blueprint $table) {
            $table->dropIndex('advertisements_status_dates_index');
            $table->dropIndex('advertisements_targeted_audience_index');
            $table->dropIndex('advertisements_targeted_language_index');
        });
    }
};
