<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ai_tool_calls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ai_message_id')->constrained()->cascadeOnDelete();
            $table->string('tool_name');
            $table->json('arguments');
            $table->text('result')->nullable();
            $table->enum('status', ['pending', 'success', 'error'])->default('pending');
            $table->timestamps();

            $table->index(['ai_message_id', 'tool_name']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ai_tool_calls');
    }
};
