<?php

declare(strict_types=1);

namespace App\Services\AiAssistant;

class MarkdownRenderer
{
    public static function render(string $text): string
    {
        // Bold: **text** -> <strong>text</strong>
        $text = preg_replace('/\*\*([^*]+)\*\*/', '<strong>$1</strong>', $text);

        // Italic: *text* -> <em>text</em>
        $text = preg_replace('/\*([^*]+)\*/', '<em>$1</em>', $text);

        // Code: `code` -> <code>code</code>
        $text = preg_replace('/`([^`]+)`/', '<code class="px-1 py-0.5 bg-gray-100 dark:bg-gray-700 rounded text-sm font-mono">$1</code>', $text);

        // Links: [text](url) -> <a href="url">text</a>
        $text = preg_replace('/\[([^\]]+)\]\(([^)]+)\)/', '<a href="$2" class="text-blue-500 hover:text-blue-700 underline" target="_blank" rel="noopener">$1</a>', $text);

        // Line breaks
        $text = nl2br($text);

        return $text;
    }
}
