<?php

declare(strict_types=1);

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AiToolCall extends Model
{
    use HasFactory;

    protected $fillable = [
        'tool_call_id',
        'ai_message_id',
        'tool_name',
        'arguments',
        'result',
        'status',
    ];

    protected function casts(): array
    {
        return [
            'arguments' => 'array',
        ];
    }

    public function message(): BelongsTo
    {
        return $this->belongsTo(AiMessage::class, 'ai_message_id');
    }

    public function scopeSuccessful($query)
    {
        return $query->where('status', 'success');
    }

    public function scopeFailed($query)
    {
        return $query->where('status', 'error');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }
}
