<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'language' => 'sometimes|string|in:en,ar',
            'ui_mode' => 'sometimes|string|in:light,dark,system',
            'notifications' => 'sometimes|array',
            'notifications.push_enabled' => 'sometimes|boolean',
        ];
    }

    /**
     * Get custom error messages for validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'language.in' => 'The selected language is not supported.',
            'ui_mode.in' => 'UI mode must be light, dark, or system.',
            'notifications.*.boolean' => 'Notification settings must be true or false.',
        ];
    }
}
