<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'category_id' => ['required', 'exists:categories,id'],
            'source' => ['required', 'in:aliexpress,amazon,noon'],
            'product_id' => ['nullable', 'string', 'max:255'],
            'image_url' => ['nullable', 'url', 'max:500'],
            'video_url' => ['nullable', 'url', 'max:500'],
            'name_ar' => ['required', 'string', 'max:255'],
            'name_en' => ['required', 'string', 'max:255'],
            'description_ar' => ['nullable', 'string'],
            'description_en' => ['nullable', 'string'],
            'price' => ['required', 'numeric', 'min:0'],
            'discount_price' => ['nullable', 'numeric', 'min:0'],
            'discount' => ['nullable', 'numeric', 'min:0', 'max:100'],
            'currency' => ['required', 'in:EGP,USD,EUR'],
            'clicks' => ['nullable', 'integer', 'min:0'],
            'direct_commission_rate' => ['nullable', 'numeric', 'min:0', 'max:100'],
            'estimated_direct_commission' => ['nullable', 'numeric', 'min:0'],
            'indirect_commission_rate' => ['nullable', 'numeric', 'min:0', 'max:100'],
            'estimated_indirect_commission' => ['nullable', 'numeric', 'min:0'],
            'sales_180day' => ['nullable', 'integer', 'min:0'],
            'positive_feedback' => ['nullable', 'numeric', 'min:0', 'max:100'],
            'promotion_url' => ['nullable', 'url', 'max:500'],
            'code_name' => ['nullable', 'string', 'max:255'],
            'code_start_time' => ['nullable', 'date'],
            'code_end_time' => ['nullable', 'date', 'after_or_equal:code_start_time'],
            'code_value' => ['nullable', 'string', 'max:255'],
            'code_quantity' => ['nullable', 'integer', 'min:0'],
            'code_minimum_spend' => ['nullable', 'numeric', 'min:0'],
        ];
    }

    /**
     * Get custom error messages for validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'category_id.required' => 'Please select a category.',
            'category_id.exists' => 'The selected category does not exist.',
            'source.required' => 'Please select a product source.',
            'source.in' => 'The selected source is invalid.',
            'name_ar.required' => 'Arabic name is required.',
            'name_en.required' => 'English name is required.',
            'price.required' => 'Price is required.',
            'price.numeric' => 'Price must be a valid number.',
            'price.min' => 'Price cannot be negative.',
            'currency.required' => 'Please select a currency.',
            'currency.in' => 'The selected currency is invalid.',
            'code_end_time.after_or_equal' => 'Code end time must be after or equal to start time.',
        ];
    }
}
