<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProfileRequest;
use App\Http\Resources\ProfileResource;
use App\Models\Profile;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ProfileController extends Controller
{
    public function store(ProfileRequest $request): Response
    {
        $profile = Profile::create([
            'user_id' => $request->user()->id,
            'gender' => $request->validated('gender'),
            'birth_date' => $request->validated('birth_date'),
            'city' => $request->validated('city'),
            'interests' => $request->validated('interests'),
            'settings' => $request->validated('settings'),
        ]);

        return response(
            new ProfileResource($profile),
            Response::HTTP_CREATED,
        );
    }

    public function show(Request $request): ProfileResource|Response
    {
        $profile = $request->user()->profile;

        if (! $profile) {
            return response(
                ['message' => 'Profile not found'],
                Response::HTTP_NOT_FOUND,
            );
        }

        return new ProfileResource($profile);
    }

    public function update(ProfileRequest $request): ProfileResource
    {
        $profile = $request->user()->profile;

        $profile->update([
            'gender' => $request->validated('gender'),
            'birth_date' => $request->validated('birth_date'),
            'city' => $request->validated('city'),
            'interests' => $request->validated('interests'),
            'settings' => $request->validated('settings'),
        ]);

        return new ProfileResource($profile);
    }
}
