@props([
    'id',
    'type' => 'line',
    'data' => [],
    'height' => 300
])

<div class="relative" style="height: {{ $height }}px">
    <canvas id="{{ $id }}"></canvas>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ctx = document.getElementById('{{ $id }}').getContext('2d');
        const isDark = document.documentElement.classList.contains('dark');

        const chartData = @json($data);

        const defaultOptions = {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    labels: {
                        color: isDark ? '#e5e7eb' : '#374151'
                    }
                }
            },
            scales: {}
        };

        if (['line', 'bar'].includes('{{ $type }}')) {
            defaultOptions.scales = {
                y: {
                    beginAtZero: true,
                    ticks: {
                        color: isDark ? '#9ca3af' : '#6b7280'
                    },
                    grid: {
                        color: isDark ? '#374151' : '#e5e7eb'
                    }
                },
                x: {
                    ticks: {
                        color: isDark ? '#9ca3af' : '#6b7280'
                    },
                    grid: {
                        color: isDark ? '#374151' : '#e5e7eb'
                    }
                }
            };
        }

        new Chart(ctx, {
            type: '{{ $type }}',
            data: chartData,
            options: defaultOptions
        });
    });
</script>
