<x-admin.layout title="Settings">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Application Settings</h2>
        <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">Manage your application configuration</p>
    </div>

    <div class="max-w-2xl">
        <x-admin.card>
            <form action="{{ route('admin.settings.update') }}" method="POST">
                @csrf
                @method('PUT')

                <div class="space-y-6">
                    <!-- General Settings -->
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">General Settings</h3>

                        <x-admin.form.input
                            name="app_name"
                            label="Application Name"
                            :value="$settings['app_name']"
                            required
                        />

                        <x-admin.form.input
                            name="app_url"
                            label="Application URL"
                            type="url"
                            :value="$settings['app_url']"
                            required
                        />
                    </div>

                    <!-- Product Settings -->
                    <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Product Settings</h3>

                        <x-admin.form.select
                            name="default_currency"
                            label="Default Currency"
                            :options="['EGP' => 'Egyptian Pound (EGP)', 'USD' => 'US Dollar (USD)', 'EUR' => 'Euro (EUR)']"
                            :value="$settings['default_currency']"
                            required
                        />
                    </div>

                    <!-- Import Settings -->
                    <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Import Settings</h3>

                        <x-admin.form.input
                            name="import_batch_size"
                            label="Import Batch Size"
                            type="number"
                            :value="$settings['import_batch_size']"
                            required
                            help="Number of products to import per batch"
                        />
                    </div>
                </div>

                <div class="mt-6 flex items-center justify-end">
                    <x-admin.form.button type="submit">Save Settings</x-admin.form.button>
                </div>
            </form>
        </x-admin.card>

        <x-admin.card class="mt-6" title="System Information">
            <dl class="space-y-3">
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">PHP Version</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ PHP_VERSION }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Laravel Version</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ app()->version() }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Environment</dt>
                    <dd class="mt-1">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ config('app.env') === 'production' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200' }}">
                            {{ strtoupper(config('app.env')) }}
                        </span>
                    </dd>
                </div>
            </dl>
        </x-admin.card>
    </div>
</x-admin.layout>
