<x-admin.layout title="View Product">
    <div class="mb-6 flex items-center justify-between">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Product Details</h2>
        <div class="flex gap-2">
            <a href="{{ route('admin.products.edit', $product) }}">
                <x-admin.form.button>Edit Product</x-admin.form.button>
            </a>
            <form action="{{ route('admin.products.destroy', $product) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this product?');">
                @csrf
                @method('DELETE')
                <x-admin.form.button type="submit" variant="danger">Delete Product</x-admin.form.button>
            </form>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Product Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Images & Media -->
            <x-admin.card title="Media">
                <div class="space-y-4">
                    @if($product->image_url)
                        <div>
                            <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-2">Product Image</h3>
                            <img src="{{ $product->image_url }}" alt="{{ $product->name_en }}" class="w-full max-w-md rounded-lg border border-gray-200 dark:border-gray-700">
                        </div>
                    @endif

                    @if($product->video_url)
                        <div>
                            <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-2">Video URL</h3>
                            <a href="{{ $product->video_url }}" target="_blank" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 break-all">
                                {{ $product->video_url }}
                            </a>
                        </div>
                    @endif
                </div>
            </x-admin.card>

            <!-- Product Names -->
            <x-admin.card title="Product Names">
                <div class="space-y-4">
                    <div>
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Name (English)</h3>
                        <p class="mt-1 text-lg font-semibold text-gray-900 dark:text-white">{{ $product->name_en }}</p>
                    </div>

                    <div>
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Name (Arabic)</h3>
                        <p class="mt-1 text-lg font-semibold text-gray-900 dark:text-white" dir="rtl">{{ $product->name_ar }}</p>
                    </div>
                </div>
            </x-admin.card>

            <!-- Descriptions -->
            <x-admin.card title="Descriptions">
                <div class="space-y-4">
                    @if($product->description_en)
                        <div>
                            <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Description (English)</h3>
                            <div class="mt-1 p-3 bg-gray-50 dark:bg-gray-900 rounded-lg text-gray-700 dark:text-gray-300 whitespace-pre-wrap">{{ $product->description_en }}</div>
                        </div>
                    @endif

                    @if($product->description_ar)
                        <div>
                            <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Description (Arabic)</h3>
                            <div class="mt-1 p-3 bg-gray-50 dark:bg-gray-900 rounded-lg text-gray-700 dark:text-gray-300 whitespace-pre-wrap" dir="rtl">{{ $product->description_ar }}</div>
                        </div>
                    @endif
                </div>
            </x-admin.card>

            <!-- Commission & Sales -->
            @if($product->direct_commission_rate || $product->indirect_commission_rate || $product->sales_180day || $product->positive_feedback || $product->clicks)
                <x-admin.card title="Commission & Sales">
                    <dl class="grid grid-cols-2 gap-4">
                        @if($product->clicks)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Clicks</dt>
                                <dd class="mt-1 text-lg font-semibold text-gray-900 dark:text-white">{{ number_format($product->clicks) }}</dd>
                            </div>
                        @endif

                        @if($product->direct_commission_rate)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Direct Commission Rate</dt>
                                <dd class="mt-1 text-lg font-semibold text-gray-900 dark:text-white">{{ $product->direct_commission_rate }}%</dd>
                            </div>
                        @endif

                        @if($product->estimated_direct_commission)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Est. Direct Commission</dt>
                                <dd class="mt-1 text-lg font-semibold text-green-600 dark:text-green-400">{{ number_format($product->estimated_direct_commission, 2) }} {{ $product->currency }}</dd>
                            </div>
                        @endif

                        @if($product->indirect_commission_rate)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Indirect Commission Rate</dt>
                                <dd class="mt-1 text-lg font-semibold text-gray-900 dark:text-white">{{ $product->indirect_commission_rate }}%</dd>
                            </div>
                        @endif

                        @if($product->estimated_indirect_commission)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Est. Indirect Commission</dt>
                                <dd class="mt-1 text-lg font-semibold text-green-600 dark:text-green-400">{{ number_format($product->estimated_indirect_commission, 2) }} {{ $product->currency }}</dd>
                            </div>
                        @endif

                        @if($product->sales_180day)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Sales (180 Days)</dt>
                                <dd class="mt-1 text-lg font-semibold text-gray-900 dark:text-white">{{ number_format($product->sales_180day) }}</dd>
                            </div>
                        @endif

                        @if($product->positive_feedback !== null)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Positive Feedback</dt>
                                <dd class="mt-1 text-lg font-semibold text-gray-900 dark:text-white">{{ $product->positive_feedback }}%</dd>
                            </div>
                        @endif
                    </dl>
                </x-admin.card>
            @endif

            <!-- Coupon Code -->
            @if($product->code_name || $product->code_start_time || $product->code_end_time || $product->code_value || $product->code_quantity || $product->code_minimum_spend)
                <x-admin.card title="Coupon Code">
                    <dl class="space-y-3">
                        @if($product->code_name)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Code Name</dt>
                                <dd class="mt-1 text-sm font-mono font-semibold text-blue-600 dark:text-blue-400 bg-blue-50 dark:bg-blue-900/30 inline-block px-2 py-1 rounded">{{ $product->code_name }}</dd>
                            </div>
                        @endif

                        @if($product->code_value)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Code Value</dt>
                                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $product->code_value }}</dd>
                            </div>
                        @endif

                        @if($product->code_start_time)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Start Time</dt>
                                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $product->code_start_time->format('M d, Y H:i') }}</dd>
                            </div>
                        @endif

                        @if($product->code_end_time)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">End Time</dt>
                                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $product->code_end_time->format('M d, Y H:i') }}</dd>
                            </div>
                        @endif

                        @if($product->code_quantity)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Quantity Available</dt>
                                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ number_format($product->code_quantity) }}</dd>
                            </div>
                        @endif

                        @if($product->code_minimum_spend)
                            <div>
                                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Minimum Spend</dt>
                                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ number_format($product->code_minimum_spend, 2) }} {{ $product->currency }}</dd>
                            </div>
                        @endif
                    </dl>
                </x-admin.card>
            @endif
        </div>

        <!-- Sidebar Info -->
        <div class="space-y-6">
            <!-- Basic Details -->
            <x-admin.card title="Basic Details">
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Category</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $product->category?->name_en ?? 'N/A' }}</dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Source</dt>
                        <dd class="mt-1">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                                {{ ucfirst($product->source) }}
                            </span>
                        </dd>
                    </div>

                    @if($product->product_id)
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Product ID</dt>
                            <dd class="mt-1 text-sm font-mono text-gray-900 dark:text-white">{{ $product->product_id }}</dd>
                        </div>
                    @endif
                </dl>
            </x-admin.card>

            <!-- Pricing -->
            <x-admin.card title="Pricing">
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Price</dt>
                        <dd class="mt-1 text-2xl font-bold text-gray-900 dark:text-white">{{ number_format($product->price, 2) }} {{ $product->currency }}</dd>
                    </div>

                    @if($product->discount_price)
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Discount Price</dt>
                            <dd class="mt-1 text-xl font-bold text-green-600 dark:text-green-400">{{ number_format($product->discount_price, 2) }} {{ $product->currency }}</dd>
                        </div>
                    @endif

                    @if($product->discount)
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Discount</dt>
                            <dd class="mt-1">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                    {{ $product->discount }}% OFF
                                </span>
                            </dd>
                        </div>
                    @endif

                    @if($product->discount_price)
                        <div class="pt-2 border-t border-gray-200 dark:border-gray-700">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">You Save</dt>
                            <dd class="mt-1 text-sm font-semibold text-green-600 dark:text-green-400">
                                {{ number_format($product->price - $product->discount_price, 2) }} {{ $product->currency }}
                            </dd>
                        </div>
                    @endif
                </dl>
            </x-admin.card>

            <!-- Promotion -->
            @if($product->promotion_url)
                <x-admin.card title="Promotion">
                    <dl class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Promotion URL</dt>
                            <dd class="mt-1">
                                <a href="{{ $product->promotion_url }}" target="_blank" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 break-all text-sm">
                                    {{ Str::limit($product->promotion_url, 60) }}
                                </a>
                            </dd>
                        </div>
                    </dl>
                </x-admin.card>
            @endif

            <!-- Metadata -->
            <x-admin.card title="Metadata">
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Created At</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $product->created_at->format('M d, Y H:i:s') }}</dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Last Updated</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $product->updated_at->format('M d, Y H:i:s') }}</dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Product ID (Internal)</dt>
                        <dd class="mt-1 text-sm font-mono text-gray-500 dark:text-gray-400">#{{ $product->id }}</dd>
                    </div>
                </dl>
            </x-admin.card>
        </div>
    </div>

    <div class="mt-6">
        <a href="{{ route('admin.products.index') }}">
            <x-admin.form.button variant="outline">Back to Products</x-admin.form.button>
        </a>
    </div>
</x-admin.layout>
