<x-admin.layout title="Advertisements">
    <div class="mb-6">
        <div class="flex items-center justify-between mb-4">
            <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Advertisements</h2>
            <a href="{{ route('admin.advertisements.create') }}">
                <x-admin.form.button>
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                    </svg>
                    Add Advertisement
                </x-admin.form.button>
            </a>
        </div>

        <!-- Filters -->
        <x-admin.card>
            <form method="GET" action="{{ route('admin.advertisements.index') }}" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                <div>
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search advertisements..."
                           class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white sm:text-sm">
                </div>
                <div>
                    <select name="status" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white sm:text-sm">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
                <div>
                    <select name="audience" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white sm:text-sm">
                        <option value="">All Audiences</option>
                        <option value="all" {{ request('audience') == 'all' ? 'selected' : '' }}>All</option>
                        <option value="male" {{ request('audience') == 'male' ? 'selected' : '' }}>Male</option>
                        <option value="female" {{ request('audience') == 'female' ? 'selected' : '' }}>Female</option>
                    </select>
                </div>
                <div>
                    <select name="language" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white sm:text-sm">
                        <option value="">All Languages</option>
                        <option value="ar" {{ request('language') == 'ar' ? 'selected' : '' }}>Arabic</option>
                        <option value="en" {{ request('language') == 'en' ? 'selected' : '' }}>English</option>
                        <option value="both" {{ request('language') == 'both' ? 'selected' : '' }}>Both</option>
                    </select>
                </div>
                <div class="flex gap-2">
                    <x-admin.form.button type="submit">Filter</x-admin.form.button>
                    <a href="{{ route('admin.advertisements.index') }}">
                        <x-admin.form.button type="button" variant="outline">Reset</x-admin.form.button>
                    </a>
                </div>
            </form>
        </x-admin.card>
    </div>

    <x-admin.card>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-900">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Image</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Title</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Schedule</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Targeting</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Sort</th>
                        <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($advertisements as $advertisement)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($advertisement->image)
                                    <img src="{{ Storage::url($advertisement->image) }}" alt="{{ $advertisement->title_en }}" class="h-16 w-24 rounded object-cover">
                                @else
                                    <div class="h-16 w-24 rounded bg-gray-200 dark:bg-gray-600 flex items-center justify-center">
                                        <svg class="h-8 w-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                        </svg>
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900 dark:text-white">{{ \Illuminate\Support\Str::limit($advertisement->title_en, 40) }}</div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">{{ \Illuminate\Support\Str::limit($advertisement->title_ar, 40) }}</div>
                                @if($advertisement->url)
                                    <a href="{{ $advertisement->url }}" target="_blank" class="text-xs text-blue-600 hover:text-blue-800 dark:text-blue-400">
                                        {{ \Illuminate\Support\Str::limit($advertisement->url, 30) }}
                                    </a>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($advertisement->status === 'active')
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                        Active
                                    </span>
                                @else
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">
                                        Inactive
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                @if($advertisement->start_date && $advertisement->end_date)
                                    {{ $advertisement->start_date->format('M d') }} - {{ $advertisement->end_date->format('M d, Y') }}
                                @elseif($advertisement->start_date)
                                    From: {{ $advertisement->start_date->format('M d, Y') }}
                                @elseif($advertisement->end_date)
                                    Until: {{ $advertisement->end_date->format('M d, Y') }}
                                @else
                                    <span class="text-gray-400">Always</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                <div class="flex flex-col gap-1">
                                    <span class="inline-flex items-center gap-1">
                                        @if($advertisement->targeted_audience === 'all')
                                            <span class="text-gray-600 dark:text-gray-300">All Users</span>
                                        @elseif($advertisement->targeted_audience === 'male')
                                            <span class="text-blue-600 dark:text-blue-400">Male</span>
                                        @else
                                            <span class="text-pink-600 dark:text-pink-400">Female</span>
                                        @endif
                                    </span>
                                    <span class="inline-flex items-center gap-1">
                                        @if($advertisement->targeted_language === 'both')
                                            <span class="text-gray-600 dark:text-gray-300">AR + EN</span>
                                        @elseif($advertisement->targeted_language === 'ar')
                                            <span>AR</span>
                                        @else
                                            <span>EN</span>
                                        @endif
                                    </span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                {{ $advertisement->sort_order }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-2">
                                <a href="{{ route('admin.advertisements.show', $advertisement) }}" class="text-blue-600 hover:text-blue-900 dark:text-blue-400">View</a>
                                <a href="{{ route('admin.advertisements.edit', $advertisement) }}" class="text-gray-600 hover:text-gray-900 dark:text-gray-400">Edit</a>
                                <form action="{{ route('admin.advertisements.destroy', $advertisement) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this advertisement?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center text-sm text-gray-500 dark:text-gray-400">
                                No advertisements found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($advertisements->hasPages())
            <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700">
                {{ $advertisements->links() }}
            </div>
        @endif
    </x-admin.card>
</x-admin.layout>
