<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RealProductSeeder extends Seeder
{
    /**
     * Real products with online images from reputable sources.
     */
    private function products(): array
    {
        // Electronics - Smartphones
        $smartphones = [
            ['name_en' => 'iPhone 15 Pro Max 256GB', 'name_ar' => 'آيفون 15 برو ماكس 256 جيجابايت', 'price' => 1199, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1592286927505-2fd5725d3f59?w=400'],
            ['name_en' => 'Samsung Galaxy S24 Ultra 512GB', 'name_ar' => 'سامسونج جالاكسي S24 ألترا 512 جيجابايت', 'price' => 1099, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1610945415295-d9bbf067e59c?w=400'],
            ['name_en' => 'Google Pixel 8 Pro 256GB', 'name_ar' => 'جوجل بكسل 8 برو 256 جيجابايت', 'price' => 899, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1598327105666-5b89351aff97?w=400'],
            ['name_en' => 'OnePlus 12 256GB', 'name_ar' => 'وان بلس 12 256 جيجابايت', 'price' => 799, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1511707171634-5f897ff02aa9?w=400'],
            ['name_en' => 'Xiaomi 14 Pro 512GB', 'name_ar' => 'شاومي 14 برو 512 جيجابايت', 'price' => 899, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1598327105666-5b89351aff97?w=400'],
            ['name_en' => 'Samsung Galaxy Z Fold 5', 'name_ar' => 'سامسونج جالاكسي Z Fold 5', 'price' => 1799, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1592899677732-2e1dc4f0a894?w=400'],
            ['name_en' => 'Samsung Galaxy Z Flip 5', 'name_ar' => 'سامسونج جالاكسي Z Flip 5', 'price' => 999, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1610945415295-d9bbf067e59c?w=400'],
            ['name_en' => 'iPhone 15 128GB', 'name_ar' => 'آيفون 15 128 جيجابايت', 'price' => 799, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1592750475338-74b7b21085ab?w=400'],
            ['name_en' => 'iPhone 14 Pro 256GB', 'name_ar' => 'آيفون 14 برو 256 جيجابايت', 'price' => 899, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1678652197835-31a3e91921a0?w=400'],
            ['name_en' => 'Google Pixel 8 128GB', 'name_ar' => 'جوجل بكسل 8 128 جيجابايت', 'price' => 699, 'category' => 'Phones & Telecommunications', 'image' => 'https://images.unsplash.com/photo-1565849904461-04a58ad377e0?w=400'],
        ];

        // Electronics - Laptops
        $laptops = [
            ['name_en' => 'MacBook Pro 16" M3 Max', 'name_ar' => 'ماك بوك برو 16 إنش M3 ماكس', 'price' => 2499, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1517336714731-489689fd1ca8?w=400'],
            ['name_en' => 'MacBook Air 15" M3', 'name_ar' => 'ماك بوك إير 15 إنش M3', 'price' => 1299, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1611186871348-b1ce696e52c9?w=400'],
            ['name_en' => 'Dell XPS 15 9530', 'name_ar' => 'ديل XPS 15 9530', 'price' => 1599, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1593642632559-0c6d3fc62b89?w=400'],
            ['name_en' => 'HP Spectre x360 14', 'name_ar' => 'HP سبيكتر x360 14', 'price' => 1399, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1588872657578-7efd1f1555ed?w=400'],
            ['name_en' => 'Lenovo ThinkPad X1 Carbon', 'name_ar' => 'لينوفو ثينك باد X1 كربون', 'price' => 1699, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1589571086129-5f78186a616a?w=400'],
            ['name_en' => 'ASUS ROG Zephyrus G16', 'name_ar' => 'إيسوس ROG زيفروس G16', 'price' => 1899, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1603302576837-37561b2e2302?w=400'],
            ['name_en' => 'Razer Blade 16', 'name_ar' => 'ريزر بلييد 16', 'price' => 2799, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1593640408182-31c70c8268f5?w=400'],
            ['name_en' => 'Microsoft Surface Laptop 5', 'name_ar' => 'مايكروسوفت سيرفس لابتوب 5', 'price' => 1299, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1611166817084-3a0c075f489b?w=400'],
            ['name_en' => 'Alienware m18 R2', 'name_ar' => 'ألين وير m18 R2', 'price' => 2299, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1593640408182-31c70c8268f5?w=400'],
            ['name_en' => 'LG Gram 17"', 'name_ar' => 'إل جي جرام 17 إنش', 'price' => 1499, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1588872657578-7efd1f1555ed?w=400'],
        ];

        // Electronics - Tablets
        $tablets = [
            ['name_en' => 'iPad Pro 12.9" M2', 'name_ar' => 'آيباد برو 12.9 إنش M2', 'price' => 1099, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1544244015-0df4b3ffc6b0?w=400'],
            ['name_en' => 'iPad Air 5th Gen', 'name_ar' => 'آيباد إير الجيل الخامس', 'price' => 599, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1561154464-82e9adf32764?w=400'],
            ['name_en' => 'Samsung Galaxy Tab S9 Ultra', 'name_ar' => 'سامسونج جالاكسي تاب S9 ألترا', 'price' => 899, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1561154464-82e9adf32764?w=400'],
            ['name_en' => 'Microsoft Surface Pro 9', 'name_ar' => 'مايكروسوفت سيرفس برو 9', 'price' => 999, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1589571086129-5f78186a616a?w=400'],
            ['name_en' => 'iPad Mini 6th Gen', 'name_ar' => 'آيباد ميني الجيل السادس', 'price' => 499, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1585790050230-5dd28404ccb9?w=400'],
            ['name_en' => 'Samsung Galaxy Tab S9+', 'name_ar' => 'سامسونج جالاكسي تاب S9+', 'price' => 699, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1561154464-82e9adf32764?w=400'],
            ['name_en' => 'Lenovo Tab P12', 'name_ar' => 'لينوفو تاب P12', 'price' => 299, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1544244015-0df4b3ffc6b0?w=400'],
            ['name_en' => 'Xiaomi Pad 6', 'name_ar' => 'شاومي باد 6', 'price' => 299, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1561154464-82e9adf32764?w=400'],
        ];

        // Electronics - Headphones & Audio
        $headphones = [
            ['name_en' => 'Sony WH-1000XM5', 'name_ar' => 'سوني WH-1000XM5', 'price' => 399, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1618366712010-f4ae9c647dcb?w=400'],
            ['name_en' => 'Apple AirPods Max', 'name_ar' => 'آبل إيربودز ماكس', 'price' => 549, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1620278638367-442dc6fd9141?w=400'],
            ['name_en' => 'Bose QuietComfort Ultra', 'name_ar' => 'بose كوايت كومفورت ألترا', 'price' => 429, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1618366712010-f4ae9c647dcb?w=400'],
            ['name_en' => 'AirPods Pro 2nd Gen', 'name_ar' => 'إيربودز برو الجيل الثاني', 'price' => 249, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1600294037681-c80b4cb5b434?w=400'],
            ['name_en' => 'Sennheiser Momentum 4', 'name_ar' => 'سنهيزر مومنتوم 4', 'price' => 349, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1618366712010-f4ae9c647dcb?w=400'],
            ['name_en' => 'Samsung Galaxy Buds2 Pro', 'name_ar' => 'سامسونج جالاكسي بادز2 برو', 'price' => 189, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1590658268037-6bf12165a8df?w=400'],
            ['name_en' => 'Sony WF-1000XM5', 'name_ar' => 'سوني WF-1000XM5', 'price' => 279, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1620278638367-442dc6fd9141?w=400'],
            ['name_en' => 'Bose QuietComfort Earbuds', 'name_ar' => 'بose كوايت كومفورت إيربادز', 'price' => 279, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1618366712010-f4ae9c647dcb?w=400'],
            ['name_en' => 'Google Pixel Buds Pro', 'name_ar' => 'جوجل بكسل بادز برو', 'price' => 199, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1590658268037-6bf12165a8df?w=400'],
            ['name_en' => 'Marshall Motif II', 'name_ar' => 'مارشال موتيف II', 'price' => 259, 'category' => 'Phones & Telecommunications Accessories', 'image' => 'https://images.unsplash.com/photo-1618366712010-f4ae9c647dcb?w=400'],
        ];

        // Electronics - Smartwatches
        $smartwatches = [
            ['name_en' => 'Apple Watch Series 9', 'name_ar' => 'آبل ووتش سيريز 9', 'price' => 399, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1546868871-7041f2a55e12?w=400'],
            ['name_en' => 'Apple Watch Ultra 2', 'name_ar' => 'آبل ووتش ألترا 2', 'price' => 799, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1579586337278-3befd40fd17a?w=400'],
            ['name_en' => 'Samsung Galaxy Watch 6', 'name_ar' => 'سامسونج جالاكسي ووتش 6', 'price' => 299, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1508685096489-7aacd43bd3b1?w=400'],
            ['name_en' => 'Garmin Fenix 7X', 'name_ar' => 'جارمين فينيكس 7X', 'price' => 899, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1546868871-7041f2a55e12?w=400'],
            ['name_en' => 'Google Pixel Watch 2', 'name_ar' => 'جوجل بكسل ووتش 2', 'price' => 349, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1508685096489-7aacd43bd3b1?w=400'],
            ['name_en' => 'Fitbit Sense 2', 'name_ar' => 'فيتبت سينس 2', 'price' => 249, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1579586337278-3befd40fd17a?w=400'],
            ['name_en' => 'Casio G-Shock Connected', 'name_ar' => 'كاسيو G-Shock المتصل', 'price' => 199, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1524592094714-0f0654e20314?w=400'],
            ['name_en' => 'Fossil Gen 6', 'name_ar' => 'فوسيل الجيل السادس', 'price' => 299, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1546868871-7041f2a55e12?w=400'],
        ];

        // Electronics - Gaming
        $gaming = [
            ['name_en' => 'PlayStation 5', 'name_ar' => 'بلايستيشن 5', 'price' => 499, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1606813907291-d86efa9b94db?w=400'],
            ['name_en' => 'Xbox Series X', 'name_ar' => 'إكس بوكس سيريز X', 'price' => 499, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1621259182978-fbf93132d53d?w=400'],
            ['name_en' => 'Nintendo Switch OLED', 'name_ar' => 'نينتندو سويتش OLED', 'price' => 349, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1578303512597-81e6cc155b3e?w=400'],
            ['name_en' => 'Steam Deck OLED', 'name_ar' => 'ستيم ديك OLED', 'price' => 549, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1592840496020-9a80228e2fd5?w=400'],
            ['name_en' => 'PlayStation 5 Pro', 'name_ar' => 'بلايستيشن 5 برو', 'price' => 699, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1606813907291-d86efa9b94db?w=400'],
            ['name_en' => 'PS5 DualSense Edge', 'name_ar' => 'تحكم PS5 DualSense Edge', 'price' => 199, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1606813907291-d86efa9b94db?w=400'],
            ['name_en' => 'Xbox Elite Controller 2', 'name_ar' => 'تحكم Xbox إيليت 2', 'price' => 179, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1621259182978-fbf93132d53d?w=400'],
            ['name_en' => 'Meta Quest 3', 'name_ar' => 'ميتا كويست 3', 'price' => 499, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1622979135225-d2ba269fb1ac?w=400'],
            ['name_en' => 'PlayStation VR2', 'name_ar' => 'بلايستيشن VR2', 'price' => 549, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1606813907291-d86efa9b94db?w=400'],
            ['name_en' => 'Nintendo Switch Lite', 'name_ar' => 'نينتندو سويتش لايت', 'price' => 199, 'category' => 'Entertainment', 'image' => 'https://images.unsplash.com/photo-1578303512597-81e6cc155b3e?w=400'],
        ];

        // Electronics - Cameras
        $cameras = [
            ['name_en' => 'Sony A7 IV', 'name_ar' => 'سوني A7 IV', 'price' => 2498, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=400'],
            ['name_en' => 'Canon EOS R6 Mark II', 'name_ar' => 'كانون EOS R6 مارك II', 'price' => 2499, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1502920917128-1aa500764cbd?w=400'],
            ['name_en' => 'Nikon Z6 III', 'name_ar' => 'نيكون Z6 III', 'price' => 2299, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1502920917128-1aa500764cbd?w=400'],
            ['name_en' => 'Fujifilm X-T5', 'name_ar' => 'فوجي فيلم X-T5', 'price' => 1699, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1502920917128-1aa500764cbd?w=400'],
            ['name_en' => 'GoPro Hero 12', 'name_ar' => 'جو برو هيرو 12', 'price' => 399, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1564462406418-6b413dd83632?w=400'],
            ['name_en' => 'DJI Mini 4 Pro', 'name_ar' => 'DJI ميني 4 برو', 'price' => 759, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1506947411487-a56738267384?w=400'],
            ['name_en' => 'DJI Mavic 3 Pro', 'name_ar' => 'DJI مافيك 3 برو', 'price' => 2199, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1506947411487-a56738267384?w=400'],
            ['name_en' => 'Canon EOS R50', 'name_ar' => 'كانون EOS R50', 'price' => 799, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1502920917128-1aa500764cbd?w=400'],
            ['name_en' => 'Sony ZV-E1', 'name_ar' => 'سوني ZV-E1', 'price' => 2198, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=400'],
            ['name_en' => 'Insta360 X4', 'name_ar' => 'إنستا 360 X4', 'price' => 449, 'category' => 'Consumer Electronics', 'image' => 'https://images.unsplash.com/photo-1564462406418-6b413dd83632?w=400'],
        ];

        // Fashion - Men's Clothing
        $mensClothing = [
            ['name_en' => 'Men\'s Classic Fit Cotton Shirt', 'name_ar' => 'قمصان قطنية كلاسيكية للرجال', 'price' => 49, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1596755094514-f87e34085b2c?w=400'],
            ['name_en' => 'Men\'s Slim Fit Chino Pants', 'name_ar' => 'بنطال شينو رجالي مضيق', 'price' => 59, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1473966968600-fa801b869a1a?w=400'],
            ['name_en' => 'Men\'s Denim Jeans', 'name_ar' => 'جينز رجالي', 'price' => 79, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1542272604-787c3835535d?w=400'],
            ['name_en' => 'Men\'s Polo Shirt', 'name_ar' => 'تيشيرت بولو رجالي', 'price' => 39, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1625910513413-5fc45e60e4e2?w=400'],
            ['name_en' => 'Men\'s Hoodie', 'name_ar' => 'هوديز رجالي', 'price' => 55, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1556821840-3a63f95609a7?w=400'],
            ['name_en' => 'Men\'s Suit Jacket', 'name_ar' => 'سترة رسمية للرجال', 'price' => 199, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400'],
            ['name_en' => 'Men\'s T-Shirt Pack', 'name_ar' => 'طقم تيشيرتات رجالي', 'price' => 29, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=400'],
            ['name_en' => 'Men\'s Shorts', 'name_ar' => 'شورت رجالي', 'price' => 35, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1591195853828-11db59a44f6b?w=400'],
            ['name_en' => 'Men\'s Leather Belt', 'name_ar' => 'حزام جلد رجالي', 'price' => 25, 'category' => 'Apparel Accessories', 'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400'],
            ['name_en' => 'Men\'s Winter Jacket', 'name_ar' => 'جاكيت شتوي رجالي', 'price' => 129, 'category' => 'Men\'s Clothing', 'image' => 'https://images.unsplash.com/photo-1551028719-00167b16eac5?w=400'],
        ];

        // Fashion - Women's Clothing
        $womensClothing = [
            ['name_en' => 'Women\'s Summer Dress', 'name_ar' => 'فستان صيفي للنساء', 'price' => 59, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1595777457583-95e059d581b8?w=400'],
            ['name_en' => 'Women\'s Blouse', 'name_ar' => 'بلوزة نسائية', 'price' => 39, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1618354691373-d851c5c3a990?w=400'],
            ['name_en' => 'Women\'s Jeans', 'name_ar' => 'جينز نسائي', 'price' => 69, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1541099649105-f69ad21f3246?w=400'],
            ['name_en' => 'Women\'s Skirt', 'name_ar' => 'تنورة نسائية', 'price' => 45, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1583496661160-fb5886a0aaaa?w=400'],
            ['name_en' => 'Women\'s Cardigan', 'name_ar' => 'كارديجان نسائي', 'price' => 49, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1434389677669-e08b4cac3105?w=400'],
            ['name_en' => 'Women\'s Leggings', 'name_ar' => 'ليغينغز نسائي', 'price' => 29, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1506629082955-511b1aa562c8?w=400'],
            ['name_en' => 'Women\'s Blazer', 'name_ar' => 'بليزر نسائي', 'price' => 89, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1591369822096-ffd140ec948f?w=400'],
            ['name_en' => 'Women\'s Sweater', 'name_ar' => 'سويتير نسائي', 'price' => 55, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1576566588028-4147f3842f27?w=400'],
            ['name_en' => 'Women\'s T-Shirt', 'name_ar' => 'تيشيرت نسائي', 'price' => 25, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1503341504253-dff4815485f1?w=400'],
            ['name_en' => 'Women\'s Coat', 'name_ar' => 'معطف نسائي', 'price' => 159, 'category' => 'Clothing & Apparel', 'image' => 'https://images.unsplash.com/photo-1539533018447-63fcce2678e3?w=400'],
        ];

        // Fashion - Shoes
        $shoes = [
            ['name_en' => 'Nike Air Max 270', 'name_ar' => 'نايك إير ماكس 270', 'price' => 150, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1542291026-7eec264c27ff?w=400'],
            ['name_en' => 'Adidas Ultraboost', 'name_ar' => 'أديداس ألترابوست', 'price' => 180, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1608231387042-66d1773070a5?w=400'],
            ['name_en' => 'New Balance 574', 'name_ar' => 'نيو بالانس 574', 'price' => 89, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1539185441755-769473a23570?w=400'],
            ['name_en' => 'Converse All Stars', 'name_ar' => 'كونفرس أول ستارز', 'price' => 65, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1606107557195-0e29a4b5b4aa?w=400'],
            ['name_en' => 'Vans Old Skool', 'name_ar' => 'فانس أولد سكول', 'price' => 70, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1525966222134-fcfa99b8ae77?w=400'],
            ['name_en' => 'Jordan 1 Retro', 'name_ar' => 'جوردان 1 ريترو', 'price' => 180, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1549298916-b41d501d3772?w=400'],
            ['name_en' => 'Timberland Boots', 'name_ar' => 'حذاء تيمبرلاند', 'price' => 160, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1608256246200-53e635b5b65f?w=400'],
            ['name_en' => 'Dr. Martens', 'name_ar' => 'دكتور مارتينز', 'price' => 150, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1608256246200-53e635b5b65f?w=400'],
            ['name_en' => 'Reebok Classic', 'name_ar' => 'ريبوك كلاسيك', 'price' => 75, 'category' => 'Shoes', 'image' => 'https://images.unsplash.com/photo-1606107557195-0e29a4b5b4aa?w=400'],
            ['name_en' => 'Puma RS-X', 'name_ar' => 'بوما RS-X', 'price' => 110, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1608231387042-66d1773070a5?w=400'],
        ];

        // Fashion - Watches
        $watches = [
            ['name_en' => 'Casio G-Shock Classic', 'name_ar' => 'كاسيو G-Shock كلاسيك', 'price' => 99, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1524592094714-0f0654e20314?w=400'],
            ['name_en' => 'Seiko 5 Sports', 'name_ar' => 'سيكو 5 سبورتس', 'price' => 299, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1523170335258-f5ed11844a49?w=400'],
            ['name_en' => 'Citizen Promaster', 'name_ar' => 'سيتزين بروماستر', 'price' => 399, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1522312346375-d1a52e2b99b3?w=400'],
            ['name_en' => 'Tissot PRX', 'name_ar' => 'تيسوت PRX', 'price' => 375, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1524592094714-0f0654e20314?w=400'],
            ['name_en' => 'Hamilton Khaki Field', 'name_ar' => 'هاميلتون خاكي فيلد', 'price' => 695, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1523170335258-f5ed11844a49?w=400'],
            ['name_en' => 'Movado Museum Classic', 'name_ar' => 'موفادو ميوزيوم كلاسيك', 'price' => 595, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1522312346375-d1a52e2b99b3?w=400'],
            ['name_en' => 'Daniel Wellington Classic', 'name_ar' => 'دانيال ويلينغتون كلاسيك', 'price' => 149, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1524592094714-0f0654e20314?w=400'],
            ['name_en' => 'Michael Kors Bradshaw', 'name_ar' => 'مايكل كورس برادشو', 'price' => 199, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1542496658-e33a6d0d50f6?w=400'],
            ['name_en' => 'Tag Heuer Formula 1', 'name_ar' => 'تاج هوير فورميولا 1', 'price' => 1299, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1523170335258-f5ed11844a49?w=400'],
            ['name_en' => 'Invicta Pro Diver', 'name_ar' => 'إنفيكتا برو دايفر', 'price' => 89, 'category' => 'Watches', 'image' => 'https://images.unsplash.com/photo-1524592094714-0f0654e20314?w=400'],
        ];

        // Fashion - Bags
        $bags = [
            ['name_en' => 'Leather Backpack', 'name_ar' => 'حقيبة جلدية للظهر', 'price' => 79, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400'],
            ['name_en' => 'Messenger Bag', 'name_ar' => 'حقيبة كروس بودي', 'price' => 65, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1548036328-c9fa89d128fa?w=400'],
            ['name_en' => 'Travel Suitcase', 'name_ar' => 'حقيبة سفر', 'price' => 149, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400'],
            ['name_en' => 'Handbag Leather', 'name_ar' => 'حقيبة يد جلدية', 'price' => 119, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1548036328-c9fa89d128fa?w=400'],
            ['name_en' => 'Gym Duffle Bag', 'name_ar' => 'حقيبة رياضية', 'price' => 45, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400'],
            ['name_en' => 'Laptop Backpack', 'name_ar' => 'حقيبة ظهر للابتوب', 'price' => 59, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400'],
            ['name_en' => 'Business Briefcase', 'name_ar' => 'حقيبة عمل', 'price' => 129, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1548036328-c9fa89d128fa?w=400'],
            ['name_en' => 'Waist Bag', 'name_ar' => 'حقيبة خصرك', 'price' => 25, 'category' => 'Luggage & Bags', 'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400'],
        ];

        // Fashion - Jewelry
        $jewelry = [
            ['name_en' => 'Silver Necklace', 'name_ar' => 'قلادة فضية', 'price' => 89, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1599643478518-a784e5dc4c8f?w=400'],
            ['name_en' => 'Gold Stud Earrings', 'name_ar' => 'أقراط ذهبية', 'price' => 149, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1535632066927-ab7c9ab60908?w=400'],
            ['name_en' => 'Tennis Bracelet', 'name_ar' => 'سوار تنس', 'price' => 299, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1573408301185-9146fe634ad0?w=400'],
            ['name_en' => 'Diamond Ring', 'name_ar' => 'خاتم ماسي', 'price' => 999, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1605100804763-247f67b3557e?w=400'],
            ['name_en' => 'Pearl Necklace', 'name_ar' => 'قلادة لؤلؤ', 'price' => 199, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1599643478518-a784e5dc4c8f?w=400'],
            ['name_en' => 'Anklet Gold', 'name_ar' => 'سوار كاحل ذهبي', 'price' => 129, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1573408301185-9146fe634ad0?w=400'],
            ['name_en' => 'Silver Charm Bracelet', 'name_ar' => 'سوار فضي بخرز', 'price' => 79, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1611085583191-a3b181a88401?w=400'],
            ['name_en' => 'Watch Gold Plated', 'name_ar' => 'ساعة ذهبية مطلي', 'price' => 179, 'category' => 'Jewelry & Accessories', 'image' => 'https://images.unsplash.com/photo-1522312346375-d1a52e2b99b3?w=400'],
        ];

        // Home & Kitchen
        $homeKitchen = [
            ['name_en' => 'Air Fryer XL', 'name_ar' => 'قلاية هوائية XL', 'price' => 129, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1626082927389-6cd097cdc6ec?w=400'],
            ['name_en' => 'Coffee Maker', 'name_ar' => 'آلة قهوة', 'price' => 89, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1517668808822-9ebb02f2a0e6?w=400'],
            ['name_en' => 'Blender Professional', 'name_ar' => 'خلاط احترافي', 'price' => 99, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1570222094114-1d8246a7a4a4?w=400'],
            ['name_en' => 'Stand Mixer', 'name_ar' => 'خلاط يدوي', 'price' => 199, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1570222094114-1d8246a7a4a4?w=400'],
            ['name_en' => 'Toaster 4-Slice', 'name_ar' => 'محمصة خبز 4 شرائح', 'price' => 49, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1558903641-248731ebd520?w=400'],
            ['name_en' => 'Electric Kettle', 'name_ar' => 'غلاية كهربائية', 'price' => 39, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1594213114663-d94db9b66d60?w=400'],
            ['name_en' => 'Food Processor', 'name_ar' => 'معالج طعام', 'price' => 119, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1570222094114-1d8246a7a4a4?w=400'],
            ['name_en' => 'Slow Cooker', 'name_ar' => 'طباخ بطيء', 'price' => 69, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1556909114-f6e7ad7d3136?w=400'],
            ['name_en' => 'Microwave Oven', 'name_ar' => 'ميكروويف', 'price' => 149, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1556909114-f6e7ad7d3136?w=400'],
            ['name_en' => 'Dishwasher Compact', 'name_ar' => 'غسالة أطباق صغيرة', 'price' => 399, 'category' => 'Home Appliances', 'image' => 'https://images.unsplash.com/photo-1584660315989-893317e13c0c?w=400'],
        ];

        // Home - Furniture
        $furniture = [
            ['name_en' => 'Office Chair Ergonomic', 'name_ar' => 'كرسي مكتب مريح', 'price' => 199, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1505843490538-5133c6c7d0e1?w=400'],
            ['name_en' => 'Standing Desk', 'name_ar' => 'مكتب وقوف', 'price' => 349, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1598300042247-d088f8ab3a91?w=400'],
            ['name_en' => 'Bookshelf Modern', 'name_ar' => 'رف كتب عصري', 'price' => 149, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1594620302200-9a762244a156?w=400'],
            ['name_en' => 'Coffee Table', 'name_ar' => 'طاولة قهوة', 'price' => 129, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1532323544230-7191fd51bc1b?w=400'],
            ['name_en' => 'Sofa 3-Seater', 'name_ar' => 'أريكة 3 مقاعد', 'price' => 599, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1555041469-a586c61ea9bc?w=400'],
            ['name_en' => 'Bed Frame King', 'name_ar' => 'هيكل سرير كينج', 'price' => 299, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1505693416388-ac5ce068fe85?w=400'],
            ['name_en' => 'Mattress Memory Foam', 'name_ar' => 'مرتبة فوم ذاكرة', 'price' => 499, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1505693416388-ac5ce068fe85?w=400'],
            ['name_en' => 'TV Stand Modern', 'name_ar' => 'وحدة تلفزيون عصرية', 'price' => 179, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1551298370-9d3d53c6a59f?w=400'],
            ['name_en' => 'Dining Table Set', 'name_ar' => 'طقم طاولة طعام', 'price' => 449, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1617806118233-18e1de247200?w=400'],
            ['name_en' => 'Wardrobe Closet', 'name_ar' => 'خزانة ملابس', 'price' => 299, 'category' => 'Furniture', 'image' => 'https://images.unsplash.com/photo-1558997519-83ea9252edf8?w=400'],
        ];

        // Home - Lighting
        $lighting = [
            ['name_en' => 'Smart LED Bulb Pack', 'name_ar' => 'طاقة لمبات LED ذكية', 'price' => 29, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1565814329452-e1efa11c5b89?w=400'],
            ['name_en' => 'Floor Lamp Modern', 'name_ar' => 'مصباح أرضي عصري', 'price' => 79, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1507473885765-e6ed057f782c?w=400'],
            ['name_en' => 'Table Lamp', 'name_ar' => 'مصباح طاولة', 'price' => 45, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1507473885765-e6ed057f782c?w=400'],
            ['name_en' => 'Ceiling Light Fixture', 'name_ar' => 'ثريا سقف', 'price' => 99, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1513506003901-1e6a229e2d15?w=400'],
            ['name_en' => 'Outdoor Solar Lights', 'name_ar' => 'إضاءة شمسية خارجية', 'price' => 39, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1550684848-fac1c5b4e853?w=400'],
            ['name_en' => 'Strip Lights LED', 'name_ar' => 'شريط إضاءة LED', 'price' => 19, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1565814329452-e1efa11c5b89?w=400'],
            ['name_en' => 'Pendant Light', 'name_ar' => 'إضاءة معلقة', 'price' => 69, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1513506003901-1e6a229e2d15?w=400'],
            ['name_en' => 'Night Light Smart', 'name_ar' => 'إضاءة ليلية ذكية', 'price' => 15, 'category' => 'Lights & Lighting', 'image' => 'https://images.unsplash.com/photo-1507473885765-e6ed057f782c?w=400'],
        ];

        // Beauty & Health
        $beauty = [
            ['name_en' => 'Face Moisturizer', 'name_ar' => 'مرطب للوجه', 'price' => 29, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1556228720-195a672e8a03?w=400'],
            ['name_en' => 'Sunscreen SPF 50', 'name_ar' => 'واقي شمسي SPF 50', 'price' => 19, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1556228720-195a672e8a03?w=400'],
            ['name_en' => 'Vitamin C Serum', 'name_ar' => 'سيروم فيتامين سي', 'price' => 35, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1620916566398-39f1143ab7be?w=400'],
            ['name_en' => 'Hair Dryer Professional', 'name_ar' => 'مجفف شعر احترافي', 'price' => 79, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1522338140262-f46f5913618a?w=400'],
            ['name_en' => 'Electric Toothbrush', 'name_ar' => 'فرشاة أسنان كهربائية', 'price' => 49, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1559467278-020177ff30b6?w=400'],
            ['name_en' => 'Perfume Collection', 'name_ar' => 'مجموعة عطور', 'price' => 89, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1541643600914-78b084683601?w=400'],
            ['name_en' => 'Makeup Palette', 'name_ar' => 'بالت مكياج', 'price' => 45, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1512496015851-a90fb38ba796?w=400'],
            ['name_en' => 'Skincare Set', 'name_ar' => 'طقم عناية بالبشرة', 'price' => 69, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1556228720-195a672e8a03?w=400'],
            ['name_en' => 'Hair Straightener', 'name_ar' => 'مكواة شعر', 'price' => 59, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1522338140264-f46f5913611a?w=400'],
            ['name_en' => 'Electric Shaver', 'name_ar' => 'شوافر كهربائي', 'price' => 69, 'category' => 'Health & Personal Care', 'image' => 'https://images.unsplash.com/photo-1626757095638-f7e27e36ea26?w=400'],
        ];

        // Sports & Fitness
        $sports = [
            ['name_en' => 'Yoga Mat Premium', 'name_ar' => 'سجادة يوغا ممتازة', 'price' => 39, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1601925260368-ae2f83cf8b7f?w=400'],
            ['name_en' => 'Adjustable Dumbbells', 'name_ar' => 'دمبل قابل للتعديل', 'price' => 149, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1534438327276-14e5300c3a48?w=400'],
            ['name_en' => 'Resistance Bands Set', 'name_ar' => 'طقم مطاط مقاومة', 'price' => 25, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1598289431512-b97b0917affc?w=400'],
            ['name_en' => 'Foam Roller', 'name_ar' => 'رغوة تدليك', 'price' => 22, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1598289431512-b97b0917affc?w=400'],
            ['name_en' => 'Water Bottle Insulated', 'name_ar' => 'زجاجة ماء معزولة', 'price' => 29, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1602143407151-7111542de6e8?w=400'],
            ['name_en' => 'Running Belt', 'name_ar' => 'حزام رياضي', 'price' => 19, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1571019614242-c5c5dee9f50b?w=400'],
            ['name_en' => 'Fitness Tracker', 'name_ar' => 'متتبع لياقة', 'price' => 79, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1575311373937-040b8e1fd5b6?w=400'],
            ['name_en' => 'Exercise Bike', 'name_ar' => 'دراجة تمارين', 'price' => 299, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1576678927484-cc907957088c?w=400'],
            ['name_en' => 'Treadmill Folding', 'name_ar' => 'جهاز مشي قابل للطي', 'price' => 499, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1576678927484-cc907957088c?w=400'],
            ['name_en' => 'Box Gloves', 'name_ar' => 'قفازات ملاكمة', 'price' => 35, 'category' => 'Sports Shoes, Clothing & Accessories', 'image' => 'https://images.unsplash.com/photo-1614632537197-38a17061c2bd?w=400'],
        ];

        // Automotive
        $automotive = [
            ['name_en' => 'Car Dash Cam', 'name_ar' => 'كاميرا سيارة', 'price' => 89, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'Car Phone Mount', 'name_ar' => 'حامل هاتف للسيارة', 'price' => 19, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'Car Vacuum Cleaner', 'name_ar' => 'مكنسة سيارة', 'price' => 35, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'Jump Starter Portable', 'name_ar' => 'مشغل سيارة محمول', 'price' => 69, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1489824904134-891ab64532f1?w=400'],
            ['name_en' => 'Tire Pressure Gauge', 'name_ar' => 'قياس ضغط الإطار', 'price' => 15, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'Car Cover Waterproof', 'name_ar' => 'غطاء سيارة مقاوم للماء', 'price' => 49, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'LED Headlight Bulbs', 'name_ar' => 'لمبات LED أمامية', 'price' => 45, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'Seat Covers Set', 'name_ar' => 'طقم غطاء مقاعد', 'price' => 39, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1552519507-da3b142c6e3d?w=400'],
            ['name_en' => 'Car Floor Mats', 'name_ar' => 'مطاط أرضيات السيارة', 'price' => 29, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1552519507-da3b142c6e3d?w=400'],
            ['name_en' => 'Bluetooth FM Transmitter', 'name_ar' => 'مذيع بلوتوث للسيارة', 'price' => 22, 'category' => 'Car Parts & Accessories', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
        ];

        // Books & Stationery
        $books = [
            ['name_en' => 'Premium Notebook Set', 'name_ar' => 'طقم دفاتر ممتازة', 'price' => 24, 'category' => 'Books & Cultural Merchandise', 'image' => 'https://images.unsplash.com/photo-1531346878377-a5be20888e57?w=400'],
            ['name_en' => 'Fountain Pen', 'name_ar' => 'قلم حبر', 'price' => 35, 'category' => 'Office & School Supplies', 'image' => 'https://images.unsplash.com/photo-1583455054006-4ff4b07787be?w=400'],
            ['name_en' => 'Desk Organizer', 'name_ar' => 'منظم مكتب', 'price' => 19, 'category' => 'Office & School Supplies', 'image' => 'https://images.unsplash.com/photo-1544531586-fde5298cdd40?w=400'],
            ['name_en' => 'Mechanical Pencils Set', 'name_ar' => 'طقم أقلام ميكانيكية', 'price' => 12, 'category' => 'Office & School Supplies', 'image' => 'https://images.unsplash.com/photo-1585336261022-680e295ce3fe?w=400'],
            ['name_en' => 'Backpack School', 'name_ar' => 'حقيبة مدرسية', 'price' => 45, 'category' => 'Office & School Supplies', 'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=400'],
            ['name_en' => 'Desk Lamp LED', 'name_ar' => 'مكتب إضاءة LED', 'price' => 29, 'category' => 'Office & School Supplies', 'image' => 'https://images.unsplash.com/photo-1507473885765-e6ed057f782c?w=400'],
            ['name_en' => 'Wireless Mouse', 'name_ar' => 'ماوس لاسلكي', 'price' => 25, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1527864550417-7fd91fc51a46?w=400'],
            ['name_en' => 'Mechanical Keyboard', 'name_ar' => 'كيبورد ميكانيكي', 'price' => 79, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1595225476474-87563907a212?w=400'],
            ['name_en' => 'USB-C Hub Multiport', 'name_ar' => 'محول USB-C متعدد', 'price' => 39, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1625723044792-44de16ccb4e9?w=400'],
            ['name_en' => 'Monitor Stand', 'name_ar' => 'حامل شاشة', 'price' => 35, 'category' => 'Computer & Office', 'image' => 'https://images.unsplash.com/photo-1527856263669-1c8e51652c2c?w=400'],
        ];

        // Baby & Kids
        $baby = [
            ['name_en' => 'Baby Stroller Compact', 'name_ar' => 'عربة أطفال مدمجة', 'price' => 149, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1591088398332-8a77919728c3?w=400'],
            ['name_en' => 'Car Seat Infant', 'name_ar' => 'مقعد سيارة للرضيع', 'price' => 129, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1591088398332-8a77919728c3?w=400'],
            ['name_en' => 'Baby Monitor Video', 'name_ar' => 'جهاز مراقبة أطفال', 'price' => 99, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1584660315989-893317e13c0c?w=400'],
            ['name_en' => 'Diaper Bag Backpack', 'name_ar' => 'حقيبة حفاضات للظهر', 'price' => 45, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1591088398332-8a77919728c3?w=400'],
            ['name_en' => 'Baby Bath Tub', 'name_ar' => 'حمام أطفال', 'price' => 29, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1584660315989-893317e13c0c?w=400'],
            ['name_en' => 'Playpen Portable', 'name_ar' => 'عبأ أطفال محمول', 'price' => 79, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1591088398332-8a77919728c3?w=400'],
            ['name_en' => 'Baby Carrier Ergonomic', 'name_ar' => 'حامل أطفال مريح', 'price' => 69, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1591088398332-8a77919728c3?w=400'],
            ['name_en' => 'Training Potty', 'name_ar' => 'نونية تدريب', 'price' => 15, 'category' => 'Mother & Kids', 'image' => 'https://images.unsplash.com/photo-1584660315989-893317e13c0c?w=400'],
        ];

        // Toys
        $toys = [
            ['name_en' => 'LEGO Technic Set', 'name_ar' => 'طقم ليغو تقني', 'price' => 129, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1587654787331-1d8f7726343f?w=400'],
            ['name_en' => 'RC Car High Speed', 'name_ar' => 'سيارة تحكم عن بعد', 'price' => 79, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1594787318286-3d835c1d207f?w=400'],
            ['name_en' => 'Drone with Camera', 'name_ar' => 'درون بكاميرا', 'price' => 99, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1506947411487-a56738267384?w=400'],
            ['name_en' => 'Board Game Collection', 'name_ar' => 'مجموعة ألعاب لوحية', 'price' => 39, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1640441472412-0b085da2f955?w=400'],
            ['name_en' => 'Art Supplies Set', 'name_ar' => 'طقم أدوات فنية', 'price' => 29, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1513519245088-0e12902e35a6?w=400'],
            ['name_en' => 'Building Blocks Mega', 'name_ar' => 'طقم مكعبات بناء', 'price' => 49, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1587654787331-1d8f7726343f?w=400'],
            ['name_en' => 'Puzzle 1000 Pieces', 'name_ar' => 'لغز 1000 قطعة', 'price' => 19, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1640441472412-0b085da2f955?w=400'],
            ['name_en' => 'Plush Animal Giant', 'name_ar' => 'دمية محشوة عملاقة', 'price' => 35, 'category' => 'Toys & Hobbies', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
        ];

        // Security & Tools
        $security = [
            ['name_en' => 'Security Camera WiFi', 'name_ar' => 'كاميرا أمنية واي فاي', 'price' => 79, 'category' => 'Security & Protection', 'image' => 'https://images.unsplash.com/photo-1557597774-9d273605dfa9?w=400'],
            ['name_en' => 'Smart Doorbell', 'name_ar' => 'جرس باب ذكي', 'price' => 149, 'category' => 'Security & Protection', 'image' => 'https://images.unsplash.com/photo-1558002038-1055907df827?w=400'],
            ['name_en' => 'Smart Lock', 'name_ar' => 'قفل ذكي', 'price' => 199, 'category' => 'Security & Protection', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'Motion Sensor Lights', 'name_ar' => 'إضاءة مستشعر حركة', 'price' => 29, 'category' => 'Security & Protection', 'image' => 'https://images.unsplash.com/photo-1550684848-fac1c5b4e853?w=400'],
            ['name_en' => 'Safe Box Digital', 'name_ar' => 'خزنة رقمية', 'price' => 119, 'category' => 'Security & Protection', 'image' => 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400'],
            ['name_en' => 'Power Drill Cordless', 'name_ar' => 'شنيور لاسلكي', 'price' => 89, 'category' => 'Tools', 'image' => 'https://images.unsplash.com/photo-1572981779307-38b8cabb2407?w=400'],
            ['name_en' => 'Tool Box Set', 'name_ar' => 'صندوق أدوات', 'price' => 79, 'category' => 'Tools', 'image' => 'https://images.unsplash.com/photo-1572981779307-1bda9c522775?w=400'],
            ['name_en' => 'Measuring Tape Digital', 'name_ar' => 'شريط قياس رقمي', 'price' => 19, 'category' => 'Tools', 'image' => 'https://images.unsplash.com/photo-1587293852726-70cdb56c2866?w=400'],
        ];

        // Merge all products
        return array_merge(
            $smartphones,
            $laptops,
            $tablets,
            $headphones,
            $smartwatches,
            $gaming,
            $cameras,
            $mensClothing,
            $womensClothing,
            $shoes,
            $watches,
            $bags,
            $jewelry,
            $homeKitchen,
            $furniture,
            $lighting,
            $beauty,
            $sports,
            $automotive,
            $books,
            $baby,
            $toys,
            $security,
        );
    }

    private function getDescription(string $name): string
    {
        return "High-quality {$name}. Perfect for everyday use with premium materials and excellent craftsmanship.";
    }

    private function getCategoryMapping(): array
    {
        return [
            'Phones & Telecommunications' => 5,
            'Phones & Telecommunications Accessories' => 5,
            'Computer & Office' => 3,
            'Consumer Electronics' => 2,
            'Entertainment' => 13,
            "Men's Clothing" => 7,
            'Clothing & Apparel' => 6,
            'Shoes' => 8,
            'Sports Shoes, Clothing & Accessories' => 9,
            'Apparel Accessories' => 11,
            'Watches' => 12,
            'Luggage & Bags' => 13,
            'Jewelry & Accessories' => 10,
            'Home Appliances' => 3,
            'Furniture' => 4,
            'Lights & Lighting' => 5,
            'Health & Personal Care' => 8,
            'Car Parts & Accessories' => 14,
            'Books & Cultural Merchandise' => 16,
            'Office & School Supplies' => 15,
            'Mother & Kids' => 9,
            'Toys & Hobbies' => 14,
            'Security & Protection' => 6,
            'Tools' => 7,
        ];
    }

    public function run(): void
    {
        $products = $this->products();
        $categoryMapping = $this->getCategoryMapping();
        $sources = ['amazon', 'aliexpress', 'noon'];
        $currencies = ['USD', 'EGP', 'SAR', 'AED'];

        $productData = [];
        $id = 1;

        foreach ($products as $product) {
            $categoryId = $categoryMapping[$product['category']] ?? 1;
            $source = $sources[array_rand($sources)];
            $currency = $currencies[array_rand($currencies)];
            $hasDiscount = (rand(1, 100) <= 60); // 60% chance of discount

            $productData[] = [
                'id' => $id++,
                'category_id' => $categoryId,
                'source' => $source,
                'name_ar' => $product['name_ar'],
                'name_en' => $product['name_en'],
                'description_ar' => $this->getDescription($product['name_ar']),
                'description_en' => $this->getDescription($product['name_en']),
                'image_url' => $product['image'],
                'video_url' => null,
                'price' => $product['price'],
                'discount_price' => $hasDiscount ? round($product['price'] * (rand(50, 90) / 100), 2) : null,
                'currency' => $currency,
                'clicks' => rand(0, 2000),
                'direct_commission_rate' => rand(2, 15) + (rand(0, 99) / 100),
                'estimated_direct_commission' => 0, // Will calculate below
                'indirect_commission_rate' => rand(1, 8) + (rand(0, 99) / 100),
                'estimated_indirect_commission' => 0, // Will calculate below
                'sales_180day' => rand(0, 500),
                'positive_feedback' => rand(80, 99) + (rand(0, 99) / 100),
                'promotion_url' => "https://example.com/product/{$id}",
                'code_name' => (rand(1, 100) <= 60) ? strtoupper(substr(md5(uniqid()), 0, 4)).rand(1000, 9999) : null,
                'code_start_time' => (rand(1, 100) <= 60) ? now()->addDays(rand(-30, 30)) : null,
                'code_end_time' => (rand(1, 100) <= 60) ? now()->addDays(rand(30, 90)) : null,
                'code_value' => (rand(1, 100) <= 60) ? rand(5, 50) + (rand(0, 99) / 100) : null,
                'code_quantity' => (rand(1, 100) <= 60) ? rand(10, 1000) : null,
                'code_minimum_spend' => (rand(1, 100) <= 60) ? rand(50, 500) + (rand(0, 99) / 100) : null,
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }

        // Calculate commissions
        foreach ($productData as &$data) {
            $basePrice = $data['discount_price'] ?? $data['price'];
            $data['estimated_direct_commission'] = round($basePrice * ($data['direct_commission_rate'] / 100), 2);
            $data['estimated_indirect_commission'] = round($basePrice * ($data['indirect_commission_rate'] / 100), 2);
        }

        // Insert in chunks
        $chunks = array_chunk($productData, 100);
        foreach ($chunks as $chunk) {
            DB::table('products')->insert($chunk);
        }

        // Add more products by creating variations to reach 500+
        $this->command->info('Creating additional product variations...');
        $additionalProducts = $this->createProductVariations($productData, count($productData) + 1);

        $chunks = array_chunk($additionalProducts, 100);
        foreach ($chunks as $chunk) {
            DB::table('products')->insert($chunk);
        }

        $totalSeeded = count($productData) + count($additionalProducts);
        $this->command->info("Seeded {$totalSeeded} real products successfully!");
    }

    private function createProductVariations(array $existingProducts, int $startId): array
    {
        $variations = [];
        $id = $startId;

        // Create variations of popular products
        $storageVariations = [128, 256, 512, 1024];
        $colorVariations = ['Black', 'White', 'Blue', 'Red', 'Green', 'Silver', 'Gray'];
        $sizeVariations = ['S', 'M', 'L', 'XL', 'XXL'];

        foreach ($existingProducts as $baseProduct) {
            // Skip if we have enough
            if (count($variations) + count($existingProducts) >= 550) {
                break;
            }

            $nameEn = $baseProduct['name_en'];
            $nameAr = $baseProduct['name_ar'];

            // Create 1-2 variations per product
            $numVariations = rand(1, 2);

            for ($i = 0; $i < $numVariations; $i++) {
                if (count($variations) + count($existingProducts) >= 550) {
                    break;
                }

                $variationType = rand(1, 4);
                $variationName = '';
                $variationNameAr = '';
                $priceAdjustment = rand(-10, 50);

                switch ($variationType) {
                    case 1: // Storage variation for electronics
                        if (stripos($nameEn, 'GB') !== false || stripos($nameEn, 'MacBook') !== false || stripos($nameEn, 'iPhone') !== false || stripos($nameEn, 'iPad') !== false) {
                            $newStorage = $storageVariations[array_rand($storageVariations)];
                            $variationName = " {$newStorage}GB";
                            $variationNameAr = " {$newStorage} جيجابايت";
                        }
                        break;
                    case 2: // Color variation
                        if (! in_array(strtolower($nameEn), ['black', 'white', 'blue', 'red', 'green'])) {
                            $color = $colorVariations[array_rand($colorVariations)];
                            $variationName = " - {$color}";
                            $variationNameAr = " - {$this->translateColor($color)}";
                        }
                        break;
                    case 3: // Size variation for clothing
                        if (stripos($nameEn, 'Shirt') !== false || stripos($nameEn, 'Pants') !== false || stripos($nameEn, 'Dress') !== false || stripos($nameEn, 'هوديز') !== false || stripos($nameEn, 'قميص') !== false) {
                            $size = $sizeVariations[array_rand($sizeVariations)];
                            $variationName = " Size {$size}";
                            $variationNameAr = " مقاس {$size}";
                        }
                        break;
                    case 4: // Pro/Plus variation
                        if (! stripos($nameEn, 'Pro') && ! stripos($nameEn, 'Plus') && ! stripos($nameEn, 'Max')) {
                            if (rand(1, 2) === 1) {
                                $variationName = ' Pro';
                                $variationNameAr = ' برو';
                            } else {
                                $variationName = ' Plus';
                                $variationNameAr = ' بلس';
                            }
                        }
                        break;
                }

                if (! empty($variationName)) {
                    $categoryId = $baseProduct['category_id'];
                    $source = $baseProduct['source'];
                    $currency = $baseProduct['currency'];
                    $hasDiscount = (rand(1, 100) <= 60);
                    $price = max(10, $baseProduct['price'] + $priceAdjustment);

                    $variations[] = [
                        'id' => $id++,
                        'category_id' => $categoryId,
                        'source' => $source,
                        'name_ar' => $nameAr.$variationNameAr,
                        'name_en' => $nameEn.$variationName,
                        'description_ar' => $this->getDescription($nameAr.$variationNameAr),
                        'description_en' => $this->getDescription($nameEn.$variationName),
                        'image_url' => $baseProduct['image_url'],
                        'video_url' => null,
                        'price' => $price,
                        'discount_price' => $hasDiscount ? round($price * (rand(50, 90) / 100), 2) : null,
                        'currency' => $currency,
                        'clicks' => rand(0, 2000),
                        'direct_commission_rate' => rand(2, 15) + (rand(0, 99) / 100),
                        'estimated_direct_commission' => 0,
                        'indirect_commission_rate' => rand(1, 8) + (rand(0, 99) / 100),
                        'estimated_indirect_commission' => 0,
                        'sales_180day' => rand(0, 500),
                        'positive_feedback' => rand(80, 99) + (rand(0, 99) / 100),
                        'promotion_url' => "https://example.com/product/{$id}",
                        'code_name' => (rand(1, 100) <= 60) ? strtoupper(substr(md5(uniqid()), 0, 4)).rand(1000, 9999) : null,
                        'code_start_time' => (rand(1, 100) <= 60) ? now()->addDays(rand(-30, 30)) : null,
                        'code_end_time' => (rand(1, 100) <= 60) ? now()->addDays(rand(30, 90)) : null,
                        'code_value' => (rand(1, 100) <= 60) ? rand(5, 50) + (rand(0, 99) / 100) : null,
                        'code_quantity' => (rand(1, 100) <= 60) ? rand(10, 1000) : null,
                        'code_minimum_spend' => (rand(1, 100) <= 60) ? rand(50, 500) + (rand(0, 99) / 100) : null,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ];
                }
            }
        }

        // Calculate commissions for variations
        foreach ($variations as &$data) {
            $basePrice = $data['discount_price'] ?? $data['price'];
            $data['estimated_direct_commission'] = round($basePrice * ($data['direct_commission_rate'] / 100), 2);
            $data['estimated_indirect_commission'] = round($basePrice * ($data['indirect_commission_rate'] / 100), 2);
        }

        return $variations;
    }

    private function translateColor(string $color): string
    {
        return match ($color) {
            'Black' => 'أسود',
            'White' => 'أبيض',
            'Blue' => 'أزرق',
            'Red' => 'أحمر',
            'Green' => 'أخضر',
            'Silver' => 'فضي',
            'Gray' => 'رمادي',
            'Gold' => 'ذهبي',
            'Pink' => 'وردي',
            'Purple' => 'بنفسجي',
            default => $color,
        };
    }
}
