<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::firstOrCreate(
            ['email' => 'admin@octopus.com'],
            [
                'first_name' => 'Admin',
                'last_name' => 'User',
                'email' => 'admin@octopus.com',
                'phone' => '01000000000',
                'password' => Hash::make(env('ADMIN_PASSWORD', 'password')),
                'is_admin' => true,
                'admin_approved_at' => now(),
                'email_verified_at' => now(),
            ]
        );
    }
}
