<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Profile>
 */
class ProfileFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => \App\Models\User::factory(),
            'gender' => fake()->randomElement(['male', 'female', 'other']),
            'birth_date' => fake()->date('Y-m-d', '-18 years'),
            'city' => fake()->city(),
            'interests' => fake()->randomElements(['sports', 'music', 'reading', 'travel', 'cooking', 'gaming'], rand(1, 3)),
            'settings' => null,
        ];
    }
}
