<?php

namespace App\Services;

class SettingsService
{
    public function getDefaults(): array
    {
        return [
            'language' => 'en',
            'ui_mode' => 'system',
            'notifications' => [
                'push_enabled' => true,
            ],
        ];
    }

    public function mergeWithDefaults(array $userSettings): array
    {
        $defaults = $this->getDefaults();

        return [
            'language' => $userSettings['language'] ?? $defaults['language'],
            'ui_mode' => $userSettings['ui_mode'] ?? $defaults['ui_mode'],
            'notifications' => array_merge(
                $defaults['notifications'],
                $userSettings['notifications'] ?? []
            ),
        ];
    }

    public function validateAndMerge(array $current, array $new): array
    {
        $merged = $current;

        if (isset($new['language'])) {
            $merged['language'] = $new['language'];
        }

        if (isset($new['ui_mode'])) {
            $merged['ui_mode'] = $new['ui_mode'];
        }

        if (isset($new['notifications'])) {
            $merged['notifications'] = array_merge(
                $current['notifications'] ?? $this->getDefaults()['notifications'],
                $new['notifications']
            );
        }

        return $merged;
    }
}
