<?php

namespace App\Http\Resources;

use App\Enums\Source;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class HomeProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'source' => $this->source,
            'image_url' => $this->image_url,
            'video_url' => $this->video_url,
            'name_ar' => $this->name_ar,
            'name_en' => $this->name_en,
            'description_ar' => $this->description_ar,
            'description_en' => $this->description_en,
            'price' => $this->price,
            'discount_price' => $this->discount_price,
            'discount' => $this->discount,
            'currency' => $this->currency,
            'positive_feedback' => $this->positive_feedback,
            'sales_180day' => $this->sales_180day,
            'promotion_url' => $this->promotion_url,
            'source_logo' => Source::from($this->source)->logo(),
        ];
    }
}
