<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'parent_id' => $this->parent_id,
            'name_ar' => $this->name_ar,
            'name_en' => $this->name_en,
            'slug' => $this->slug,
            'description_ar' => $this->description_ar,
            'description_en' => $this->description_en,
            'image' => $this->image,
            'icon' => $this->icon,
            'status' => $this->status,
            'position' => $this->position,
            'meta_title' => $this->meta_title,
            'meta_description' => $this->meta_description,
            'parent' => $this->whenLoaded('parent', function () {
                return [
                    'id' => $this->parent->id,
                    'name_ar' => $this->parent->name_ar,
                    'name_en' => $this->parent->name_en,
                    'slug' => $this->parent->slug,
                ];
            }),
            'children' => CategoryResource::collection($this->whenLoaded('children')),
            'children_count' => $this->when(isset($this->children_count), $this->children_count),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
